/*
 * Decompiled with CFR 0.152.
 */
package org.example.provider;

import com.xforceplus.tech.base.anno.KV;
import com.xforceplus.tech.base.anno.OnScene;
import com.xforceplus.tech.base.scene.DynamicSceneProvider;
import com.xforceplus.tech.base.scene.Scene;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.example.provider.TaggedScene;

public class TaggedProvider
implements DynamicSceneProvider {
    public List<Scene> getSceneViaContext(Map<String, Object> map) {
        TaggedScene taggedScene = new TaggedScene();
        taggedScene.setTagged("Whatever");
        return Collections.singletonList(taggedScene);
    }

    public List<Scene> filterScene(List<Scene> list) {
        return list.stream().filter(x -> x instanceof TaggedScene).collect(Collectors.toList());
    }

    public int matchScore(OnScene scenesOnTarget, List<Scene> scenes) {
        List safeScenes = Optional.ofNullable(scenes).orElseGet(Collections::emptyList);
        if (safeScenes.isEmpty()) {
            return -1;
        }
        KV[] scenesKV = scenesOnTarget.scenes();
        Optional<KV> tagged = Arrays.stream(scenesKV).filter(kv -> kv.k().equals("tagged")).findFirst();
        if (!tagged.isPresent()) {
            return -1;
        }
        Optional<Scene> first = safeScenes.stream().filter(x -> x instanceof TaggedScene).filter(x -> ((TaggedScene)x).getTagged().equalsIgnoreCase(((KV)tagged.get()).v())).findFirst();
        return first.isPresent() ? 10 : -1;
    }
}

