/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.condition;

import java.util.Arrays;

public enum MatchModeEnum {
    AND(0, "and"),
    OR(1, "or");

    private final int code;
    private final String name;

    public static String getMatchModeByCode(int code) {
        return Arrays.stream(MatchModeEnum.values()).filter(e -> e.code == code).findFirst().orElse(AND).getName();
    }

    public static MatchModeEnum getMatchModeByName(String name) {
        return Arrays.stream(MatchModeEnum.values()).filter(e -> e.name.equalsIgnoreCase(name)).findFirst().orElse(AND);
    }

    private MatchModeEnum(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }
}

