/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.condition;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public enum ParamTypeEnum {
    POST("post", true),
    URI("uri", false),
    QUERY("query", true),
    HOST("host", true),
    IP("ip", true),
    HEADER("header", true),
    PAYLOAD("payload", true);

    private final String name;
    private final Boolean support;

    public static List<ParamTypeEnum> acquireSupport() {
        return Arrays.stream(ParamTypeEnum.values()).filter(e -> e.support).collect(Collectors.toList());
    }

    public static ParamTypeEnum getParamTypeEnumByName(String name) {
        return Arrays.stream(ParamTypeEnum.values()).filter(e -> e.getName().equals(name) && e.support != false).findFirst().orElseThrow(() -> new RuntimeException(" this  param type can not support!"));
    }

    private ParamTypeEnum(String name, Boolean support) {
        this.name = name;
        this.support = support;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getSupport() {
        return this.support;
    }
}

