/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.condition.judge;

import com.google.common.collect.Maps;
import com.xforceplus.apollo.condition.OperatorEnum;
import com.xforceplus.apollo.condition.judge.EqOperatorJudge;
import com.xforceplus.apollo.condition.judge.GTOperatorJudge;
import com.xforceplus.apollo.condition.judge.LTOperatorJudge;
import com.xforceplus.apollo.condition.judge.LikeOperatorJudge;
import com.xforceplus.apollo.condition.judge.MatchOperatorJudge;
import com.xforceplus.apollo.condition.judge.NotEqOperatorJudge;
import com.xforceplus.apollo.condition.judge.OperatorJudge;
import com.xforceplus.apollo.condition.judge.RegExOperatorJudge;
import com.xforceplus.apollo.zookeeper.model.Condition;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class OperatorJudgeFactory {
    private static final Map<String, OperatorJudge> OPERATOR_JUDGE_MAP = Maps.newHashMapWithExpectedSize((int)7);

    public static Boolean judge(Condition conditionZkDTO, String realData) {
        if (Objects.isNull(conditionZkDTO) || StringUtils.isBlank((CharSequence)realData)) {
            return false;
        }
        return OPERATOR_JUDGE_MAP.get(conditionZkDTO.getOperator()).judge(conditionZkDTO, realData);
    }

    static {
        OPERATOR_JUDGE_MAP.put(OperatorEnum.EQ.getAlias(), new EqOperatorJudge());
        OPERATOR_JUDGE_MAP.put(OperatorEnum.MATCH.getAlias(), new MatchOperatorJudge());
        OPERATOR_JUDGE_MAP.put(OperatorEnum.LIKE.getAlias(), new LikeOperatorJudge());
        OPERATOR_JUDGE_MAP.put(OperatorEnum.REGEX.getAlias(), new RegExOperatorJudge());
        OPERATOR_JUDGE_MAP.put(OperatorEnum.NotEQ.getAlias(), new NotEqOperatorJudge());
        OPERATOR_JUDGE_MAP.put(OperatorEnum.GT.getAlias(), new GTOperatorJudge());
        OPERATOR_JUDGE_MAP.put(OperatorEnum.LT.getAlias(), new LTOperatorJudge());
    }
}

