/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.condition.strategy;

import com.google.common.collect.Maps;
import com.xforceplus.apollo.condition.MatchModeEnum;
import com.xforceplus.apollo.condition.strategy.AndMatchStrategy;
import com.xforceplus.apollo.condition.strategy.MatchStrategy;
import com.xforceplus.apollo.condition.strategy.OrMatchStrategy;
import java.util.Map;

public class MatchStrategyFactory {
    private static final Map<Integer, MatchStrategy> MATCH_STRATEGY_MAP = Maps.newHashMapWithExpectedSize((int)2);

    public static MatchStrategy of(Integer strategy) {
        return MATCH_STRATEGY_MAP.get(strategy);
    }

    static {
        MATCH_STRATEGY_MAP.put(MatchModeEnum.AND.getCode(), new AndMatchStrategy());
        MATCH_STRATEGY_MAP.put(MatchModeEnum.OR.getCode(), new OrMatchStrategy());
    }
}

