package com.xforceplus.apollo.cost;

import com.xforceplus.apollo.config.ClientConfig;
import com.xforceplus.apollo.config.Config;
import com.xforceplus.apollo.config.refresh.ConfigRefreshThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassMethodConfig extends Config {
    private static Logger logger = LoggerFactory.getLogger(ClassMethodConfig.class);
    //配置文件路径
    private static String configFile = "class_method.properties";

    private static ClassMethodConfig config = null;
    private ClassMethodConfig(String configFile){ super(configFile); }

    public static ClassMethodConfig getConfig()
    {
        if (null == config)
        {
            synchronized (ClientConfig.class)
            {
                config = new ClassMethodConfig(configFile);
                ConfigRefreshThread.getConfigRefreshThread().addRefreshConfig(configFile,config);
            }
        }
        return config;
    }
}
