package com.xforceplus.apollo.cost;

import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import org.apache.commons.lang3.StringUtils;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CostTransformer implements ClassFileTransformer {

    private final static String prefix = "\nlong startTime = System.currentTimeMillis();\n";
    private final static String postfix = "\nlong endTime = System.currentTimeMillis();\n";

    // 被处理的方法列表
    private final static Map<String, List<String>> methodMap = new HashMap<String, List<String>>();

    public CostTransformer() {
        //对指定方法监控
        String classMethdStrings = ClassMethodConfig.getConfig().getProperty("class.methods");
        if (StringUtils.isNotBlank(classMethdStrings)){
            String[] classMethods = classMethdStrings.split(",");
            for (String classMethod:classMethods){
                add(classMethod);
            }
        }
    }

    private void add(String methodString) {
        String className = methodString.substring(0, methodString.lastIndexOf("."));
        String methodName = methodString.substring(methodString.lastIndexOf(".") + 1);
        List<String> list = methodMap.get(className);
        if (list == null) {
            list = new ArrayList<String>();
            methodMap.put(className, list);
        }
        list.add(methodName);
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined,
                            ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        className = className.replace("/", ".");
        // 判断加载的class的包路径是不是需要监控的类
        if (methodMap.containsKey(className)) {
            CtClass ctclass = null;
            try {
                ctclass = ClassPool.getDefault().get(className);// 使用全称,用于取得字节码类<使用javassist>
                for (String methodName : methodMap.get(className)) {
                    String outputStr = "\nSystem.out.println(\"监控信息(执行耗时)：" + className + "." + methodName + " => \" +(endTime - startTime) +\"毫秒\");";
                    CtMethod ctmethod = ctclass.getDeclaredMethod(methodName);// 得到这方法实例
                    String type = ctmethod.getReturnType().getName();
                    String newMethodName = methodName + "$new";// 新定义一个方法叫做比如queryUserAge$new
                    ctmethod.setName(newMethodName);// 将原来的方法名字修改
                    // 创建新的方法，复制原来的方法，名字为原来的名字
                    CtMethod newMethod = CtNewMethod.copy(ctmethod, methodName, ctclass, null);
                    // 构建新的方法体
                    StringBuilder methodBodyStr = new StringBuilder();
                    methodBodyStr.append("{");
                    methodBodyStr.append(prefix);
                    /** 判断老方法返回类型 */
                    if(!"void".equals(type)){
                        /** 类似 Object result = newName(args0,args1); */
                        methodBodyStr.append(type + " result = ");
                    }
                    /** 执行老方法 */
                    methodBodyStr.append(newMethodName + "($$);\n");// 调用原有代码，类似于method();($$)表示所有的参数
                    methodBodyStr.append(postfix);
                    methodBodyStr.append(outputStr);
                    if(!"void".equals(type)){
                        /** 类似 Object result = newName(args0,args1); */
                        methodBodyStr.append("return result;\n");
                    }
                    methodBodyStr.append("}");
                    newMethod.setBody(methodBodyStr.toString());// 替换新方法
                    ctclass.addMethod(newMethod);         // 增加新方法
                }
                return ctclass.toBytecode();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}
