/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.cost;

import com.xforceplus.apollo.cost.ClassMethodConfig;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import org.apache.commons.lang3.StringUtils;

public class CostTransformer
implements ClassFileTransformer {
    private static final String prefix = "\nlong startTime = System.currentTimeMillis();\n";
    private static final String postfix = "\nlong endTime = System.currentTimeMillis();\n";
    private static final Map<String, List<String>> methodMap = new HashMap<String, List<String>>();

    public CostTransformer() {
        String classMethdStrings = ClassMethodConfig.getConfig().getProperty("class.methods");
        if (StringUtils.isNotBlank((CharSequence)classMethdStrings)) {
            String[] classMethods;
            for (String classMethod : classMethods = classMethdStrings.split(",")) {
                this.add(classMethod);
            }
        }
    }

    private void add(String methodString) {
        String className = methodString.substring(0, methodString.lastIndexOf("."));
        String methodName = methodString.substring(methodString.lastIndexOf(".") + 1);
        List<String> list = methodMap.get(className);
        if (list == null) {
            list = new ArrayList<String>();
            methodMap.put(className, list);
        }
        list.add(methodName);
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (methodMap.containsKey(className = className.replace("/", "."))) {
            CtClass ctclass = null;
            try {
                ctclass = ClassPool.getDefault().get(className);
                for (String methodName : methodMap.get(className)) {
                    String outputStr = "\nSystem.out.println(\"\u76d1\u63a7\u4fe1\u606f(\u6267\u884c\u8017\u65f6)\uff1a" + className + "." + methodName + " => \" +(endTime - startTime) +\"\u6beb\u79d2\");";
                    CtMethod ctmethod = ctclass.getDeclaredMethod(methodName);
                    String type = ctmethod.getReturnType().getName();
                    String newMethodName = methodName + "$new";
                    ctmethod.setName(newMethodName);
                    CtMethod newMethod = CtNewMethod.copy((CtMethod)ctmethod, (String)methodName, (CtClass)ctclass, null);
                    StringBuilder methodBodyStr = new StringBuilder();
                    methodBodyStr.append("{");
                    methodBodyStr.append(prefix);
                    if (!"void".equals(type)) {
                        methodBodyStr.append(type + " result = ");
                    }
                    methodBodyStr.append(newMethodName + "($$);\n");
                    methodBodyStr.append(postfix);
                    methodBodyStr.append(outputStr);
                    if (!"void".equals(type)) {
                        methodBodyStr.append("return result;\n");
                    }
                    methodBodyStr.append("}");
                    newMethod.setBody(methodBodyStr.toString());
                    ctclass.addMethod(newMethod);
                }
                return ctclass.toBytecode();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

