/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.crypt;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.xforceplus.apollo.crypt.UserMessage;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;

public class JacksonUtil {
    private ObjectMapper mapper = new ObjectMapper();
    private static volatile JacksonUtil jacksonUtil;

    private JacksonUtil() {
        this.mapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
    }

    private JacksonUtil(JsonInclude.Include include) {
        this.mapper.setSerializationInclusion(include);
    }

    public JacksonUtil(JsonInclude.Include include, SimpleDateFormat fmt) {
        this.mapper.setSerializationInclusion(include);
        this.mapper.setDateFormat((DateFormat)fmt);
    }

    public <T> T fromJson(String jsonString, Class<T> clazz) {
        if (StringUtils.isEmpty((CharSequence)jsonString)) {
            return null;
        }
        Object t = null;
        try {
            t = this.mapper.readValue(jsonString, clazz);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (T)t;
    }

    public String toJson(Object object) {
        String json_str = "[]";
        try {
            json_str = this.mapper.writeValueAsString(object);
            return json_str;
        }
        catch (Exception e) {
            json_str = "[]";
            throw new RuntimeException(e);
        }
        finally {
            return json_str;
        }
    }

    public String toJson(Object object, String filterName) throws Exception {
        String json_str = "[]";
        try {
            SimpleFilterProvider filterProvider = new SimpleFilterProvider().addFilter(filterName, SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[0]));
            json_str = this.mapper.writer((FilterProvider)filterProvider).writeValueAsString(object);
            return json_str;
        }
        catch (Exception e) {
            json_str = "[]";
            throw new Exception(e);
        }
        finally {
            return json_str;
        }
    }

    public String toJson(Object object, String[] args, String filterName) throws Exception {
        String json = "[]";
        try {
            if (this.mapper == null) {
            }
            SimpleFilterProvider filterProvider = new SimpleFilterProvider().addFilter(filterName, SimpleBeanPropertyFilter.serializeAllExcept((String[])args));
            json = this.mapper.writer((FilterProvider)filterProvider).writeValueAsString(object);
            return json;
        }
        catch (Exception e) {
            json = "[]";
            throw new Exception(e);
        }
        finally {
            return json;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JacksonUtil getInstance() {
        if (null != jacksonUtil) return jacksonUtil;
        Class<JacksonUtil> clazz = JacksonUtil.class;
        synchronized (JacksonUtil.class) {
            if (null != jacksonUtil) return jacksonUtil;
            jacksonUtil = new JacksonUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return jacksonUtil;
        }
    }

    @Deprecated
    public static JacksonUtil getInstance(JsonInclude.Include include) {
        return new JacksonUtil(include);
    }

    @Deprecated
    public static JacksonUtil getInstance(JsonInclude.Include include, SimpleDateFormat fmt) {
        if (fmt == null) {
            fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        return new JacksonUtil(include, fmt);
    }

    public static void main(String[] args) {
        JacksonUtil jacksonUtil = JacksonUtil.getInstance();
        JacksonUtil jacksonUtil1 = JacksonUtil.getInstance();
        UserMessage userMessage = new UserMessage();
        userMessage.setUser_account("123");
        userMessage.setEmail("@13123");
        try {
            HashMap map = new HashMap();
            HashMap<String, String> maps = new HashMap<String, String>();
            maps.put("message", "arg");
            ArrayList<UserMessage> list = new ArrayList<UserMessage>();
            list.add(userMessage);
            map.put("String", list);
            String arg = jacksonUtil1.toJson(map, "UserMessage");
            String[] argv = new String[]{"user_account"};
            String str = jacksonUtil.toJson(userMessage, argv, "UserMessage");
            String json = jacksonUtil1.toJson(maps);
            System.out.println(arg);
            System.out.println(str);
            System.out.println(json);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

