/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.crypt;

import com.xforceplus.apollo.crypt.sm.Cipher;
import com.xforceplus.apollo.crypt.sm.SM2;
import com.xforceplus.apollo.crypt.sm.SMUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.math.ec.ECPoint;

public class SM2Util {
    private static final String PUBLIC_KEY = "ECPublicKey";
    private static final String PRIVATE_KEY = "ECPrivateKey";

    public static Map<String, String> initKey() {
        SM2 sm2 = SM2.Instance();
        AsymmetricCipherKeyPair key = sm2.ecc_key_pair_generator.generateKeyPair();
        ECPrivateKeyParameters ecpriv = (ECPrivateKeyParameters)key.getPrivate();
        ECPublicKeyParameters ecpub = (ECPublicKeyParameters)key.getPublic();
        BigInteger privateKey = ecpriv.getD();
        ECPoint publicKey = ecpub.getQ();
        HashMap<String, String> keyMap = new HashMap<String, String>();
        keyMap.put(PUBLIC_KEY, SMUtil.byteToHex(publicKey.getEncoded()));
        keyMap.put(PRIVATE_KEY, SMUtil.byteToHex(privateKey.toByteArray()));
        return keyMap;
    }

    public static String encrypt(String publicKeyStr, String content) throws IOException {
        byte[] source = new byte[content.getBytes().length];
        System.arraycopy(content.getBytes(), 0, source, 0, content.getBytes().length);
        Cipher cipher = new Cipher();
        SM2 sm2 = SM2.Instance();
        ECPoint userKey = sm2.ecc_curve.decodePoint(SMUtil.hexStringToBytes(publicKeyStr));
        ECPoint c1 = cipher.Init_enc(sm2, userKey);
        cipher.Encrypt(source);
        byte[] c3 = new byte[32];
        cipher.Dofinal(c3);
        return SMUtil.byteToHex(c1.getEncoded()) + SMUtil.byteToHex(source) + SMUtil.byteToHex(c3);
    }

    public static String decrypt(String privateKeyStr, String encryptedData) throws IOException {
        byte[] bytes = SMUtil.hexStringToBytes(encryptedData);
        byte[] c1Bytes = SMUtil.hexToByte(encryptedData.substring(0, 130));
        int c2Len = bytes.length - 97;
        byte[] c2 = SMUtil.hexToByte(encryptedData.substring(130, 130 + 2 * c2Len));
        byte[] c3 = SMUtil.hexToByte(encryptedData.substring(130 + 2 * c2Len, 194 + 2 * c2Len));
        SM2 sm2 = SM2.Instance();
        BigInteger userD = new BigInteger(1, SMUtil.hexStringToBytes(privateKeyStr));
        ECPoint c1 = sm2.ecc_curve.decodePoint(c1Bytes);
        Cipher cipher = new Cipher();
        cipher.Init_dec(userD, c1);
        cipher.Decrypt(c2);
        cipher.Dofinal(c3);
        return new String(c2);
    }

    public static void main(String[] args) throws Exception {
        Map<String, String> keys = SM2Util.initKey();
        String plainText = "{\"userId\":\"gjj\",\"userName\":\"123\"}";
        String prik = "75DE707D3AABFB77322467A9F3B5E644C9D321D6167CA794CA2620E087F95A6E";
        String pubk = "04CE5AE5B2D8D4D632188CF1492BB482A41EA9E607421A49D4792E8328EF7B00BD84CF735EDDC145F580FB4BF131899A2590E2B3E8EAC41E1ED322498FDDCF75E9";
        System.out.println("\u52a0\u5bc6: ");
        String cipherText = SM2Util.encrypt(pubk, plainText);
        System.out.println(cipherText);
        System.out.println("\u89e3\u5bc6: ");
        plainText = SM2Util.decrypt(prik, cipherText);
        System.out.println(plainText);
    }
}

