/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.crypt.signature;

import com.xforceplus.apollo.crypt.SignatureException;
import com.xforceplus.apollo.crypt.signature.SignatureInf;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DsaSignature
implements SignatureInf {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String KEY_ALGORITHM = "DSA";
    private static final int KEY_SIZE = 1024;
    private KeyPair keyPair;
    private byte[] privateKey;
    private byte[] publicKey;

    public DsaSignature() {
        try {
            this.keyPair = this.initKey();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
    }

    public DsaSignature(String privateKey, String publicKey) {
        this.privateKey = Base64.decodeBase64((String)privateKey);
        this.publicKey = Base64.decodeBase64((String)publicKey);
    }

    public byte[] signature(byte[] data, byte[] privateKey) throws Exception {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKey);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey key = keyFactory.generatePrivate(keySpec);
        Signature signature = Signature.getInstance(DsaTypeEn.SHA1withDSA.name());
        signature.initSign(key);
        signature.update(data);
        return signature.sign();
    }

    @Override
    public String signature(String customerNo, String timestamp, String nonce, String body) throws SignatureException {
        if (null == this.privateKey) {
            throw new SignatureException(-40003);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(customerNo);
        sb.append(timestamp);
        sb.append(nonce);
        sb.append(body);
        String signaure = null;
        try {
            signaure = Base64.encodeBase64String((byte[])this.signature(sb.toString().getBytes(), this.privateKey));
        }
        catch (Exception e) {
            throw new SignatureException(-40003);
        }
        return signaure;
    }

    public boolean verify(byte[] data, byte[] publicKey, byte[] sign) throws Exception {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKey);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey key = keyFactory.generatePublic(keySpec);
        Signature signature = Signature.getInstance(DsaTypeEn.SHA1withDSA.name());
        signature.initVerify(key);
        signature.update(data);
        return signature.verify(sign);
    }

    private KeyPair initKey() throws Exception {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        keyPairGen.initialize(1024);
        return keyPairGen.genKeyPair();
    }

    public byte[] getPublicKey() {
        return this.keyPair == null ? this.publicKey : this.keyPair.getPublic().getEncoded();
    }

    public byte[] getPrivateKey() {
        return this.keyPair == null ? this.privateKey : this.keyPair.getPrivate().getEncoded();
    }

    public static void main(String[] args) throws Exception {
        String msg = "Hello World";
        DsaSignature dsa1 = new DsaSignature();
        byte[] privateKey = dsa1.getPrivateKey();
        byte[] publicKey = dsa1.getPublicKey();
        DsaSignature dsa2 = new DsaSignature(null, Base64.encodeBase64String((byte[])publicKey));
        byte[] sign = dsa1.signature(msg.getBytes(), dsa1.getPrivateKey());
        boolean flag = dsa2.verify(msg.getBytes(), dsa2.getPublicKey(), sign);
        String result = flag ? "\u6570\u5b57\u7b7e\u540d\u5339\u914d" : "\u6570\u5b57\u7b7e\u540d\u4e0d\u5339\u914d";
        System.out.println("\u6570\u5b57\u7b7e\u540d\uff1a" + Base64.encodeBase64URLSafeString((byte[])sign));
        System.out.println("\u9a8c\u8bc1\u7ed3\u679c\uff1a" + result);
    }

    public static enum DsaTypeEn {
        MD5withDSA,
        SHA1withDSA;

    }
}

