/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.crypt;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;

public class GMEncryptUtil {
    static final Charset ENCODING_UTF8 = StandardCharsets.UTF_8;
    private static final String PUBLIC_KEY = "ECPublicKey";
    private static final String PRIVATE_KEY = "ECPrivateKey";

    public static String encrypt(String publicKeyStr, String content) {
        try {
            byte[] pubkey = GMEncryptUtil.hexToByte(publicKeyStr);
            byte[] cbs = content.getBytes(ENCODING_UTF8);
            BouncyCastleProvider bc = new BouncyCastleProvider();
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(pubkey);
            KeyFactory keyFactory = KeyFactory.getInstance("EC", (Provider)bc);
            PublicKey publicK = keyFactory.generatePublic(x509EncodedKeySpec);
            BCECPublicKey publicKey = (BCECPublicKey)publicK;
            ECParameterSpec ecParameterSpec = publicKey.getParameters();
            ECDomainParameters domainParameters = new ECDomainParameters(ecParameterSpec.getCurve(), ecParameterSpec.getG(), ecParameterSpec.getN());
            ECPublicKeyParameters publicKeyParameters = new ECPublicKeyParameters(publicKey.getQ(), domainParameters);
            SM2Engine engine = new SM2Engine();
            engine.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)publicKeyParameters, new SecureRandom()));
            return GMEncryptUtil.byteToHex(engine.processBlock(cbs, 0, cbs.length));
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    public static String decrypt(String privateKeyStr, String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            throw new SecurityException("\u5f85\u52a0\u5bc6\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            byte[] prikey = GMEncryptUtil.hexToByte(privateKeyStr);
            byte[] cbs = GMEncryptUtil.hexToByte(content);
            BouncyCastleProvider bc = new BouncyCastleProvider();
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(prikey);
            KeyFactory keyFactory = KeyFactory.getInstance("EC", (Provider)bc);
            PrivateKey privateK = keyFactory.generatePrivate(pkcs8KeySpec);
            BCECPrivateKey privateKey = (BCECPrivateKey)privateK;
            ECParameterSpec ecParameterSpec = privateKey.getParameters();
            ECDomainParameters domainParameters = new ECDomainParameters(ecParameterSpec.getCurve(), ecParameterSpec.getG(), ecParameterSpec.getN());
            ECPrivateKeyParameters privateKeyParameters = new ECPrivateKeyParameters(privateKey.getD(), domainParameters);
            SM2Engine engine = new SM2Engine();
            engine.init(false, (CipherParameters)privateKeyParameters);
            return new String(engine.processBlock(cbs, 0, cbs.length), ENCODING_UTF8);
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    public static Map<String, String> initKey() {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            X9ECParameters sm2ECParameters = GMNamedCurves.getByName((String)"sm2p256v1");
            ECParameterSpec ecParameterSpec = new ECParameterSpec(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN());
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC", "BC");
            keyPairGenerator.initialize((AlgorithmParameterSpec)ecParameterSpec, new SecureRandom());
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            HashMap<String, String> keyMap = new HashMap<String, String>();
            PublicKey publicKey = keyPair.getPublic();
            PrivateKey privateKey = keyPair.getPrivate();
            byte[] publicKeyEncode = publicKey.getEncoded();
            byte[] privateKeyEncoded = privateKey.getEncoded();
            keyMap.put(PUBLIC_KEY, GMEncryptUtil.byteToHex(publicKeyEncode));
            keyMap.put(PRIVATE_KEY, GMEncryptUtil.byteToHex(privateKeyEncoded));
            return keyMap;
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    public static byte[] hexToByte(String hex) throws IllegalArgumentException {
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException();
        }
        char[] arr = hex.toCharArray();
        byte[] b = new byte[hex.length() / 2];
        int i = 0;
        int j = 0;
        int l = hex.length();
        while (i < l) {
            String swap = "" + arr[i++] + arr[i];
            int byteint = Integer.parseInt(swap, 16) & 0xFF;
            b[j] = new Integer(byteint).byteValue();
            ++i;
            ++j;
        }
        return b;
    }

    public static String byteToHex(byte[] b) {
        if (b == null) {
            throw new IllegalArgumentException("Argument b ( byte array ) is null! ");
        }
        String hs = "";
        String stmp = "";
        for (int n = 0; n < b.length; ++n) {
            stmp = Integer.toHexString(b[n] & 0xFF);
            hs = stmp.length() == 1 ? hs + "0" + stmp : hs + stmp;
        }
        return hs.toUpperCase();
    }

    public static void main(String[] args) {
        String plainText = "{\"code\":\"1\",\"message\":\"success1\"}";
        Map<String, String> keyMap = GMEncryptUtil.initKey();
        String publicKeyStr = keyMap.get(PUBLIC_KEY);
        String privateKeyStr = keyMap.get(PRIVATE_KEY);
        System.out.println("publicKeyStr:" + publicKeyStr);
        System.out.println("privateKeyStr:" + privateKeyStr);
        long s = System.currentTimeMillis();
        String mw = GMEncryptUtil.encrypt(publicKeyStr, plainText);
        System.out.println("\u52a0\u5bc6\u540e:" + mw);
        String jm = GMEncryptUtil.decrypt(privateKeyStr, mw);
        System.out.println("\u89e3\u5bc6\u540e:" + jm);
        System.out.println("\u5904\u7406\u603b\u8017\u65f6:" + (System.currentTimeMillis() - s));
    }
}

