/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.crypt;

import com.xforceplus.apollo.crypt.CryptException;
import com.xforceplus.apollo.crypt.PKCS7Encoder;
import com.xforceplus.apollo.crypt.SignatureException;
import com.xforceplus.apollo.crypt.signature.DsaSignature;
import com.xforceplus.apollo.crypt.signature.SHA1Signature;
import com.xforceplus.apollo.crypt.signature.SignatureInf;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class MsgDecrypt {
    static Charset CHARSET = StandardCharsets.UTF_8;
    SignatureInf signature;
    byte[] aesKey;
    String customerNo;
    String platformNo;

    public MsgDecrypt(String customerNo, String password, String platformNo) throws CryptException {
        if (password.length() != 43) {
            throw new CryptException(-40004);
        }
        this.customerNo = customerNo;
        this.platformNo = platformNo;
        this.aesKey = Base64.decodeBase64((String)(password + "="));
        this.signature = new SHA1Signature();
    }

    public MsgDecrypt(String customerNo, String password, String platformNo, String publicKey) throws CryptException {
        this(customerNo, password, platformNo);
        this.signature = new DsaSignature(null, publicKey);
    }

    int recoverNetworkBytesOrder(byte[] orderBytes) {
        int sourceNumber = 0;
        for (int i = 0; i < 4; ++i) {
            sourceNumber <<= 8;
            sourceNumber |= orderBytes[i] & 0xFF;
        }
        return sourceNumber;
    }

    String decrypt(String text) throws CryptException {
        String from_appid;
        String xmlContent;
        byte[] original;
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec key_spec = new SecretKeySpec(this.aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(Arrays.copyOfRange(this.aesKey, 0, 16));
            cipher.init(2, (Key)key_spec, iv);
            byte[] encrypted = Base64.decodeBase64((String)text);
            original = cipher.doFinal(encrypted);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CryptException(-40007);
        }
        try {
            byte[] bytes = PKCS7Encoder.decode(original);
            byte[] networkOrder = Arrays.copyOfRange(bytes, 16, 20);
            int xmlLength = this.recoverNetworkBytesOrder(networkOrder);
            xmlContent = new String(Arrays.copyOfRange(bytes, 20, 20 + xmlLength), CHARSET);
            from_appid = new String(Arrays.copyOfRange(bytes, 20 + xmlLength, bytes.length), CHARSET);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CryptException(-40008);
        }
        if (!from_appid.equals(this.platformNo)) {
            throw new CryptException(-40005);
        }
        return xmlContent;
    }

    public String decryptMsg(String msgSignature, String timeStamp, String nonce, String postData) throws Exception {
        boolean notAltered = true;
        if (StringUtils.isNotBlank((CharSequence)this.customerNo)) {
            if (this.signature instanceof DsaSignature) {
                DsaSignature dsaSignature = (DsaSignature)this.signature;
                StringBuffer sb = new StringBuffer();
                sb.append(this.customerNo);
                sb.append(timeStamp);
                sb.append(nonce);
                sb.append(postData);
                notAltered = dsaSignature.verify(sb.toString().getBytes(), ((DsaSignature)this.signature).getPublicKey(), Base64.decodeBase64((String)msgSignature));
            } else {
                String sign = this.signature.signature(this.customerNo, timeStamp, nonce, postData);
                if (!sign.equals(msgSignature)) {
                    notAltered = false;
                }
            }
            if (!notAltered) {
                throw new CryptException(-40001);
            }
        }
        String result = this.decrypt(postData);
        return result;
    }

    public String verifyURL(String msgSignature, String timeStamp, String nonce, String echoStr) throws CryptException, SignatureException {
        String sign = this.signature.signature(this.customerNo, timeStamp, nonce, echoStr);
        if (!sign.equals(msgSignature)) {
            throw new CryptException(-40001);
        }
        String result = this.decrypt(echoStr);
        return result;
    }
}

