/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.crypt;

import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;

public class AESUtil {
    private static final String DEFAULT_ALGORITHM = "SHA1PRNG";
    private static final int DEFAULT_RANDOM_BIT = 128;

    public static String encrypt(String content, String password) throws Exception {
        return AESUtil.encrypt(content, password, DEFAULT_ALGORITHM, 128);
    }

    public static String decrypt(String encrypt, String password) throws Exception {
        return AESUtil.decrypt(encrypt, password, DEFAULT_ALGORITHM, 128);
    }

    public static String encrypt(String content, String password, String secureRandomAlgorithm, int secureRandomBit) throws Exception {
        if (StringUtils.isBlank((CharSequence)secureRandomAlgorithm)) {
            return AESUtil.encrypt(content, password);
        }
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        SecureRandom random = SecureRandom.getInstance(secureRandomAlgorithm);
        random.setSeed(password.getBytes());
        kgen.init(secureRandomBit, random);
        SecretKey secretKey = kgen.generateKey();
        byte[] enCodeFormat = secretKey.getEncoded();
        SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        byte[] byteContent = content.getBytes("utf-8");
        cipher.init(1, key);
        byte[] result = cipher.doFinal(byteContent);
        return AESUtil.parseByte2HexStr(result);
    }

    public static String encrypt(String content, String password, String secureRandomAlgorithm, String secureRandomBitStr) throws Exception {
        if (StringUtils.isBlank((CharSequence)secureRandomAlgorithm)) {
            return AESUtil.encrypt(content, password);
        }
        int secureRandomBit = Integer.valueOf(secureRandomBitStr);
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        SecureRandom random = SecureRandom.getInstance(secureRandomAlgorithm);
        random.setSeed(password.getBytes());
        kgen.init(secureRandomBit, random);
        SecretKey secretKey = kgen.generateKey();
        byte[] enCodeFormat = secretKey.getEncoded();
        SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        byte[] byteContent = content.getBytes("utf-8");
        cipher.init(1, key);
        byte[] result = cipher.doFinal(byteContent);
        return AESUtil.parseByte2HexStr(result);
    }

    public static String decrypt(String encrypt, String password, String secureRandomAlgorithm, int secureRandomBit) throws Exception {
        if (StringUtils.isBlank((CharSequence)secureRandomAlgorithm)) {
            return AESUtil.decrypt(encrypt, password);
        }
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        SecureRandom random = SecureRandom.getInstance(secureRandomAlgorithm);
        random.setSeed(password.getBytes());
        kgen.init(secureRandomBit, random);
        SecretKey secretKey = kgen.generateKey();
        byte[] enCodeFormat = secretKey.getEncoded();
        SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, key);
        byte[] result = cipher.doFinal(AESUtil.parseHexStr2Byte(encrypt));
        return new String(result);
    }

    public static String decrypt(String encrypt, String password, String secureRandomAlgorithm, String secureRandomBitStr) throws Exception {
        if (StringUtils.isBlank((CharSequence)secureRandomAlgorithm)) {
            return AESUtil.decrypt(encrypt, password);
        }
        int secureRandomBit = Integer.valueOf(secureRandomBitStr);
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        SecureRandom random = SecureRandom.getInstance(secureRandomAlgorithm);
        random.setSeed(password.getBytes());
        kgen.init(secureRandomBit, random);
        SecretKey secretKey = kgen.generateKey();
        byte[] enCodeFormat = secretKey.getEncoded();
        SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, key);
        byte[] result = cipher.doFinal(AESUtil.parseHexStr2Byte(encrypt));
        return new String(result);
    }

    public static String parseByte2HexStr(byte[] buf) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buf.length; ++i) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }

    public static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; ++i) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        String content = "this is test \u8fd9\u662f\u6d4b\u8bd5";
        String password = "test1234567890";
        String secureRandomAlgorithm = DEFAULT_ALGORITHM;
        int secureRandomBit = 128;
        String encryptTxt = AESUtil.encrypt(content, password);
        System.out.println(encryptTxt);
        String decryptTxt = AESUtil.decrypt(encryptTxt, password);
        System.out.println(decryptTxt);
    }
}

