/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.crypt;

import com.xforceplus.apollo.crypt.ByteGroup;
import com.xforceplus.apollo.crypt.CallBackData;
import com.xforceplus.apollo.crypt.CryptException;
import com.xforceplus.apollo.crypt.JacksonUtil;
import com.xforceplus.apollo.crypt.MsgDecrypt;
import com.xforceplus.apollo.crypt.PKCS7Encoder;
import com.xforceplus.apollo.crypt.SignatureException;
import com.xforceplus.apollo.crypt.signature.DsaSignature;
import com.xforceplus.apollo.crypt.signature.SHA1Signature;
import com.xforceplus.apollo.crypt.signature.SignatureInf;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Arrays;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class MsgCrypt {
    static Charset CHARSET = StandardCharsets.UTF_8;
    SignatureInf signature;
    byte[] aesKey;
    String customerNo;
    String platformNo;

    public MsgCrypt(String customerNo, String password, String platformNo) throws CryptException {
        if (password.length() != 43) {
            throw new CryptException(-40004);
        }
        this.customerNo = customerNo;
        this.platformNo = platformNo;
        this.aesKey = Base64.decodeBase64((String)(password + "="));
        this.signature = new SHA1Signature();
    }

    public MsgCrypt(String customerNo, String password, String platformNo, String privateKey) throws CryptException {
        this(customerNo, password, platformNo);
        this.signature = new DsaSignature(privateKey, null);
    }

    byte[] getNetworkBytesOrder(int sourceNumber) {
        byte[] orderBytes = new byte[4];
        orderBytes[3] = (byte)(sourceNumber & 0xFF);
        orderBytes[2] = (byte)(sourceNumber >> 8 & 0xFF);
        orderBytes[1] = (byte)(sourceNumber >> 16 & 0xFF);
        orderBytes[0] = (byte)(sourceNumber >> 24 & 0xFF);
        return orderBytes;
    }

    int recoverNetworkBytesOrder(byte[] orderBytes) {
        int sourceNumber = 0;
        for (int i = 0; i < 4; ++i) {
            sourceNumber <<= 8;
            sourceNumber |= orderBytes[i] & 0xFF;
        }
        return sourceNumber;
    }

    public String getRandomStr() {
        String base = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 16; ++i) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    public String encrypt(String randomStr, String text) throws CryptException {
        ByteGroup byteCollector = new ByteGroup();
        byte[] randomStrBytes = randomStr.getBytes(CHARSET);
        byte[] textBytes = text.getBytes(CHARSET);
        byte[] networkBytesOrder = this.getNetworkBytesOrder(textBytes.length);
        byte[] appidBytes = this.platformNo.getBytes(CHARSET);
        byteCollector.addBytes(randomStrBytes);
        byteCollector.addBytes(networkBytesOrder);
        byteCollector.addBytes(textBytes);
        byteCollector.addBytes(appidBytes);
        byte[] padBytes = PKCS7Encoder.encode(byteCollector.size());
        byteCollector.addBytes(padBytes);
        byte[] unencrypted = byteCollector.toBytes();
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec keySpec = new SecretKeySpec(this.aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(this.aesKey, 0, 16);
            cipher.init(1, (Key)keySpec, iv);
            byte[] encrypted = cipher.doFinal(unencrypted);
            String base64Encrypted = Base64.encodeBase64String((byte[])encrypted);
            return base64Encrypted;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CryptException(-40006);
        }
    }

    String decrypt(String text) throws CryptException {
        String from_appid;
        String xmlContent;
        byte[] original;
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec key_spec = new SecretKeySpec(this.aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(Arrays.copyOfRange(this.aesKey, 0, 16));
            cipher.init(2, (Key)key_spec, iv);
            byte[] encrypted = Base64.decodeBase64((String)text);
            original = cipher.doFinal(encrypted);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CryptException(-40007);
        }
        try {
            byte[] bytes = PKCS7Encoder.decode(original);
            byte[] networkOrder = Arrays.copyOfRange(bytes, 16, 20);
            int xmlLength = this.recoverNetworkBytesOrder(networkOrder);
            xmlContent = new String(Arrays.copyOfRange(bytes, 20, 20 + xmlLength), CHARSET);
            from_appid = new String(Arrays.copyOfRange(bytes, 20 + xmlLength, bytes.length), CHARSET);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CryptException(-40008);
        }
        if (!from_appid.equals(this.platformNo)) {
            throw new CryptException(-40005);
        }
        return xmlContent;
    }

    public String encryptMsg(String replyMsg, String timeStamp, String nonce) throws CryptException, SignatureException {
        String encrypt = this.encrypt(this.getRandomStr(), replyMsg);
        if (timeStamp == "") {
            timeStamp = Long.toString(System.currentTimeMillis());
        }
        String sign = this.signature.signature(this.customerNo, timeStamp, nonce, encrypt);
        CallBackData callBackData = new CallBackData();
        callBackData.setBody(encrypt);
        callBackData.setNonce(nonce);
        callBackData.setSign(sign);
        callBackData.setTimeStamp(timeStamp);
        return JacksonUtil.getInstance().toJson(callBackData);
    }

    public String decryptMsg(String msgSignature, String customerNo, String timeStamp, String nonce, String postData) throws CryptException, SignatureException {
        String sign = this.signature.signature(customerNo, timeStamp, nonce, postData);
        if (!sign.equals(msgSignature)) {
            throw new CryptException(-40001);
        }
        String result = this.decrypt(postData);
        return result;
    }

    public String verifyURL(String msgSignature, String timeStamp, String nonce, String echoStr) throws CryptException, SignatureException {
        String sign = this.signature.signature(this.customerNo, timeStamp, nonce, echoStr);
        if (!sign.equals(msgSignature)) {
            throw new CryptException(-40001);
        }
        String result = this.decrypt(echoStr);
        return result;
    }

    public static void main(String[] args) throws Exception {
        String password = "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb";
        MsgCrypt msgCrypt = new MsgCrypt("aaa", password, "ccc");
        String encryptMsg1 = msgCrypt.encrypt(msgCrypt.getRandomStr(), "ea\u4f60\u597dee");
        MsgDecrypt msgDecrypt = new MsgDecrypt("aaa", password, "ccc");
        String encryptMsg2 = msgCrypt.encryptMsg("ea\u4f60\u597dee", System.currentTimeMillis() + "", "5324523");
        encryptMsg2 = msgDecrypt.decryptMsg("323b2dfc5101b22db8d8fd63ee837caa5b8e679a", "1521720219060", "5324523", "Tahhtc3MP+Z5L81HmvV/kJIuADCRjF57qvf49j8jPlWDUzsbXKTU9A+ZgFzeFP5QbF1ODP24DYyvnVFm1EvxDQ==");
        System.out.println(encryptMsg2);
        System.out.println(encryptMsg1);
        System.out.println(msgCrypt.decrypt(encryptMsg1));
        DsaSignature sign = new DsaSignature();
        password = "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb";
        msgCrypt = new MsgCrypt("aaa", password, "ccc", Base64.encodeBase64String((byte[])sign.getPrivateKey()));
        encryptMsg1 = msgCrypt.encrypt(msgCrypt.getRandomStr(), "ea\u4f60\u597dee");
        msgDecrypt = new MsgDecrypt(null, password, "ccc", Base64.encodeBase64String((byte[])sign.getPublicKey()));
        encryptMsg2 = msgCrypt.encryptMsg("ea\u4f60\u597dee", System.currentTimeMillis() + "", "5324523");
        CallBackData callBackData = JacksonUtil.getInstance().fromJson(encryptMsg2, CallBackData.class);
        System.out.println(JacksonUtil.getInstance().toJson(callBackData));
        encryptMsg2 = msgDecrypt.decryptMsg(callBackData.getSign(), callBackData.getTimeStamp(), callBackData.getNonce(), callBackData.getBody());
        System.out.println(encryptMsg2);
        System.out.println(encryptMsg1);
        System.out.println(msgCrypt.decrypt(encryptMsg1));
    }
}

