/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.crypt;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;

public class RSAUtil {
    public static final String KEY_ALGORITHM = "RSA";
    private static final int KEY_SIZE = 512;
    private static final String PUBLIC_KEY = "RSAPublicKey";
    private static final String PRIVATE_KEY = "RSAPrivateKey";
    private static final String SIGN_METHOD = "SHA256WithRSA";

    public static Map<String, String> initKey() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        keyPairGenerator.initialize(512);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        HashMap<String, String> keyMap = new HashMap<String, String>();
        keyMap.put(PUBLIC_KEY, Base64.getEncoder().encodeToString(publicKey.getEncoded()));
        keyMap.put(PRIVATE_KEY, Base64.getEncoder().encodeToString(privateKey.getEncoded()));
        return keyMap;
    }

    public static String encryptByPrivateKey(String privateKeyStr, String content) throws Exception {
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(privateKeyStr));
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(1, privateKey);
        return Base64.getEncoder().encodeToString(cipher.doFinal(content.getBytes()));
    }

    public static String encryptByPublicKey(String publicKeyStr, String content) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(Base64.getDecoder().decode(publicKeyStr));
        PublicKey pubKey = keyFactory.generatePublic(x509KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(1, pubKey);
        return Base64.getEncoder().encodeToString(cipher.doFinal(content.getBytes()));
    }

    public static String decryptByPrivateKey(String privateKeyStr, String content) throws Exception {
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(privateKeyStr));
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(2, privateKey);
        return new String(cipher.doFinal(Base64.getDecoder().decode(content.getBytes())));
    }

    public static String decryptByPublicKey(String publicKeyStr, String content) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(Base64.getDecoder().decode(publicKeyStr));
        PublicKey pubKey = keyFactory.generatePublic(x509KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(2, pubKey);
        return new String(cipher.doFinal(Base64.getDecoder().decode(content)));
    }

    public static String getPrivateKey(Map<String, String> keyMap) {
        return keyMap.get(PRIVATE_KEY);
    }

    public static String getPublicKey(Map<String, String> keyMap) throws Exception {
        return keyMap.get(PUBLIC_KEY);
    }

    public static String sign(String content, String privateKey, String encode) {
        try {
            PKCS8EncodedKeySpec priPKCS8 = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(privateKey));
            KeyFactory keyf = KeyFactory.getInstance(KEY_ALGORITHM);
            PrivateKey priKey = keyf.generatePrivate(priPKCS8);
            Signature signature = Signature.getInstance(SIGN_METHOD);
            signature.initSign(priKey);
            signature.update(content.getBytes(encode));
            byte[] signed = signature.sign();
            return Base64.getEncoder().encodeToString(signed);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String sign(String content, String privateKey) {
        try {
            PKCS8EncodedKeySpec priPKCS8 = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(privateKey));
            KeyFactory keyf = KeyFactory.getInstance(KEY_ALGORITHM);
            PrivateKey priKey = keyf.generatePrivate(priPKCS8);
            Signature signature = Signature.getInstance(SIGN_METHOD);
            signature.initSign(priKey);
            signature.update(content.getBytes());
            byte[] signed = signature.sign();
            return Base64.getEncoder().encodeToString(signed);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean doCheck(String content, String sign, String publicKey, String encode) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            byte[] encodedKey = Base64.getDecoder().decode(publicKey);
            PublicKey pubKey = keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
            Signature signature = Signature.getInstance(SIGN_METHOD);
            signature.initVerify(pubKey);
            signature.update(content.getBytes(encode));
            boolean bverify = signature.verify(Base64.getDecoder().decode(sign));
            return bverify;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean doCheck(String content, String sign, String publicKey) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            byte[] encodedKey = Base64.getDecoder().decode(publicKey);
            PublicKey pubKey = keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
            Signature signature = Signature.getInstance(SIGN_METHOD);
            signature.initVerify(pubKey);
            signature.update(content.getBytes());
            boolean bverify = signature.verify(Base64.getDecoder().decode(sign));
            return bverify;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void main(String[] args) throws Exception {
        Map<String, String> keyMap = RSAUtil.initKey();
        System.out.println("\u516c\u94a5\uff1a/n" + keyMap.get(PUBLIC_KEY));
        System.out.println("\u79c1\u94a5\uff1a/n" + keyMap.get(PRIVATE_KEY));
        System.out.println("================\u5bc6\u94a5\u5bf9\u6784\u9020\u5b8c\u6bd5,\u7532\u65b9\u5c06\u516c\u94a5\u516c\u5e03\u7ed9\u4e59\u65b9\uff0c\u5f00\u59cb\u8fdb\u884c\u52a0\u5bc6\u6570\u636e\u7684\u4f20\u8f93=============");
        String str = "RSA\u5bc6\u7801\u4ea4\u6362\u7b97\u6cd5";
        System.out.println("/n===========\u7532\u65b9\u5411\u4e59\u65b9\u53d1\u9001\u52a0\u5bc6\u6570\u636e==============");
        System.out.println("\u539f\u6587:" + str);
        String code1 = RSAUtil.encryptByPrivateKey(keyMap.get(PRIVATE_KEY), str);
        System.out.println("\u52a0\u5bc6\u540e\u7684\u6570\u636e\uff1a" + code1);
        System.out.println("===========\u4e59\u65b9\u4f7f\u7528\u7532\u65b9\u63d0\u4f9b\u7684\u516c\u94a5\u5bf9\u6570\u636e\u8fdb\u884c\u89e3\u5bc6==============");
        String decode1 = RSAUtil.decryptByPublicKey(keyMap.get(PUBLIC_KEY), code1);
        System.out.println("\u4e59\u65b9\u89e3\u5bc6\u540e\u7684\u6570\u636e\uff1a" + decode1 + "/n/n");
        System.out.println("===========\u53cd\u5411\u8fdb\u884c\u64cd\u4f5c\uff0c\u4e59\u65b9\u5411\u7532\u65b9\u53d1\u9001\u6570\u636e==============/n/n");
        str = "\u4e59\u65b9\u5411\u7532\u65b9\u53d1\u9001\u6570\u636eRSA\u7b97\u6cd5";
        System.out.println("\u539f\u6587:" + str);
        String code2 = RSAUtil.encryptByPublicKey(keyMap.get(PUBLIC_KEY), str);
        System.out.println("===========\u4e59\u65b9\u4f7f\u7528\u516c\u94a5\u5bf9\u6570\u636e\u8fdb\u884c\u52a0\u5bc6==============");
        System.out.println("\u52a0\u5bc6\u540e\u7684\u6570\u636e\uff1a" + code2);
        System.out.println("=============\u4e59\u65b9\u5c06\u6570\u636e\u4f20\u9001\u7ed9\u7532\u65b9======================");
        System.out.println("===========\u7532\u65b9\u4f7f\u7528\u79c1\u94a5\u5bf9\u6570\u636e\u8fdb\u884c\u89e3\u5bc6==============");
        String decode2 = RSAUtil.decryptByPrivateKey(keyMap.get(PRIVATE_KEY), code2);
        System.out.println("\u7532\u65b9\u89e3\u5bc6\u540e\u7684\u6570\u636e\uff1a" + decode2);
        String content = "\u4f60\u597d\u554aaaa===========\u7532\u65b9\u4f7f\u7528\u79c1\u94a5\u5bf9\u6570\u636e\u8fdb\u884c\u89e3\u5bc6==============";
        int count = 0;
        while (true) {
            String sign = RSAUtil.sign(content, keyMap.get(PRIVATE_KEY));
            System.out.println(RSAUtil.doCheck(content + "1", sign, keyMap.get(PUBLIC_KEY)));
            if (++count % 100 != 0) continue;
            System.out.println(count);
        }
    }
}

