/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.crypt;

import com.xforceplus.apollo.crypt.sm.Cipher;
import com.xforceplus.apollo.crypt.sm.SM2;
import com.xforceplus.apollo.crypt.sm.SMUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.math.ec.ECPoint;

public class SM2Util {
    private static final String PUBLIC_KEY = "ECPublicKey";
    private static final String PRIVATE_KEY = "ECPrivateKey";

    public static Map<String, String> initKey() {
        SM2 sm2 = SM2.Instance();
        AsymmetricCipherKeyPair key = sm2.ecc_key_pair_generator.generateKeyPair();
        ECPrivateKeyParameters ecpriv = (ECPrivateKeyParameters)key.getPrivate();
        ECPublicKeyParameters ecpub = (ECPublicKeyParameters)key.getPublic();
        BigInteger privateKey = ecpriv.getD();
        ECPoint publicKey = ecpub.getQ();
        HashMap<String, String> keyMap = new HashMap<String, String>();
        keyMap.put(PUBLIC_KEY, SMUtil.byteToHex(publicKey.getEncoded()));
        keyMap.put(PRIVATE_KEY, SMUtil.byteToHex(privateKey.toByteArray()));
        return keyMap;
    }

    public static String encrypt(String publicKeyStr, String content) throws IOException {
        byte[] source = new byte[content.getBytes().length];
        System.arraycopy(content.getBytes(), 0, source, 0, content.getBytes().length);
        Cipher cipher = new Cipher();
        SM2 sm2 = SM2.Instance();
        ECPoint userKey = sm2.ecc_curve.decodePoint(SMUtil.hexStringToBytes(publicKeyStr));
        ECPoint c1 = cipher.Init_enc(sm2, userKey);
        cipher.Encrypt(source);
        byte[] c3 = new byte[32];
        cipher.Dofinal(c3);
        return SMUtil.byteToHex(c1.getEncoded()) + SMUtil.byteToHex(source) + SMUtil.byteToHex(c3);
    }

    public static String decrypt(String privateKeyStr, String encryptedData) throws IOException {
        byte[] bytes = SMUtil.hexStringToBytes(encryptedData);
        byte[] c1Bytes = SMUtil.hexToByte(encryptedData.substring(0, 130));
        int c2Len = bytes.length - 97;
        byte[] c2 = SMUtil.hexToByte(encryptedData.substring(130, 130 + 2 * c2Len));
        byte[] c3 = SMUtil.hexToByte(encryptedData.substring(130 + 2 * c2Len, 194 + 2 * c2Len));
        SM2 sm2 = SM2.Instance();
        BigInteger userD = new BigInteger(1, SMUtil.hexStringToBytes(privateKeyStr));
        ECPoint c1 = sm2.ecc_curve.decodePoint(c1Bytes);
        Cipher cipher = new Cipher();
        cipher.Init_dec(userD, c1);
        cipher.Decrypt(c2);
        cipher.Dofinal(c3);
        return new String(c2);
    }

    public static void main(String[] args) throws Exception {
        Map<String, String> keys = SM2Util.initKey();
        String plainText = "{\"userId\":\"gjj\",\"userName\":\"123\"}";
        String pubk = "308201333081EC06072A8648CE3D02013081E0020101302C06072A8648CE3D0101022100FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF30440420FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC042028E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E9304410432C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0022100FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D5412302010103420004A32FA4FF3FC9B65F863F54BE964292A5E4A54F34585A1A56CC0085480D162C76E043DFCAD075F177C3145D1368B56B7085082911477B4C627E93ED590A8D50A2";
        String prik = "3082024B0201003081EC06072A8648CE3D02013081E0020101302C06072A8648CE3D0101022100FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF30440420FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC042028E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E9304410432C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0022100FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D5412302010104820155308201510201010420FC59A5F84B1778939176430B7B36253114A41907FE574732C60730A360908B13A081E33081E0020101302C06072A8648CE3D0101022100FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF30440420FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC042028E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E9304410432C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0022100FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123020101A14403420004A32FA4FF3FC9B65F863F54BE964292A5E4A54F34585A1A56CC0085480D162C76E043DFCAD075F177C3145D1368B56B7085082911477B4C627E93ED590A8D50A2";
        System.out.println("\u52a0\u5bc6: ");
        String cipherText = SM2Util.encrypt(pubk, plainText);
        System.out.println(cipherText);
        System.out.println("\u89e3\u5bc6: ");
        plainText = SM2Util.decrypt(prik, cipherText);
        System.out.println(plainText);
    }
}

