/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.crypt;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

public class ECDSAUtil {
    public static final String KEY_ALGORITHM = "EC";
    private static final String SIGNATURE_ALGORITHM = "SHA256withECDSA";
    private static final int KEY_SIZE = 256;
    private static final String PUBLIC_KEY = "ECPublicKey";
    private static final String PRIVATE_KEY = "ECPrivateKey";

    public static Map<String, String> initKey() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        keyPairGenerator.initialize(256);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        ECPublicKey ecPublicKey = (ECPublicKey)keyPair.getPublic();
        ECPrivateKey ecPrivateKey = (ECPrivateKey)keyPair.getPrivate();
        HashMap<String, String> keyMap = new HashMap<String, String>();
        keyMap.put(PUBLIC_KEY, Base64.getEncoder().encodeToString(ecPublicKey.getEncoded()));
        keyMap.put(PRIVATE_KEY, Base64.getEncoder().encodeToString(ecPrivateKey.getEncoded()));
        return keyMap;
    }

    public static String sign(String privateKeyStr, String content) throws Exception {
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(privateKeyStr));
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey privateKey = keyFactory.generatePrivate(pkcs8EncodedKeySpec);
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initSign(privateKey);
        signature.update(content.getBytes());
        byte[] sign = signature.sign();
        return Base64.getEncoder().encodeToString(sign);
    }

    public static boolean verifySign(String publicKeyStr, String sign, String content) throws Exception {
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(Base64.getDecoder().decode(publicKeyStr));
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initVerify(publicKey);
        signature.update(content.getBytes());
        return signature.verify(Base64.getDecoder().decode(sign));
    }

    public static void main(String[] args) throws Exception {
        String content = "hello xx";
        Map<String, String> keys = ECDSAUtil.initKey();
        String sign = ECDSAUtil.sign(keys.get(PRIVATE_KEY), content);
        System.out.println(ECDSAUtil.verifySign(keys.get(PUBLIC_KEY), sign, content));
    }
}

