/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.crypt;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import org.apache.commons.codec.binary.Hex;

public final class SignUtil {
    public static void main(String[] args) throws Exception {
        String content = "study hard and make progress everyday";
        System.out.println("content :" + content);
        KeyPair keyPair = SignUtil.getKeyPair(512);
        String publicKey = Hex.encodeHexString((byte[])keyPair.getPublic().getEncoded());
        String privateKey = Hex.encodeHexString((byte[])keyPair.getPrivate().getEncoded());
        String md5Sign = SignUtil.sign16("MD5withRSA", content, privateKey);
        System.out.println("sign with md5 and rsa :" + md5Sign);
        boolean md5Verifty = SignUtil.verify16("MD5withRSA", content, md5Sign, publicKey);
        System.out.println("verify sign with md5 and rsa :" + md5Verifty);
        String sha1Sign = SignUtil.sign16("SHA1withRSA", content, privateKey);
        System.out.println("sign with sha1 and rsa :" + sha1Sign);
        boolean sha1Verifty = SignUtil.verify16("SHA1withRSA", content, sha1Sign, publicKey);
        System.out.println("verify sign with sha1 and rsa :" + sha1Verifty);
    }

    public static KeyPair getKeyPair(int keySize) throws Exception {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(keySize);
        KeyPair keyPair = keyGen.generateKeyPair();
        return keyPair;
    }

    public static boolean verify64(String method, String content, String sign, String publicKey) throws Exception {
        byte[] contentBytes = content.getBytes("utf-8");
        Signature signature = Signature.getInstance(method);
        byte[] encodedKey = Base64.getDecoder().decode(publicKey);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey pubKey = keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
        signature.initVerify(pubKey);
        signature.update(contentBytes);
        return signature.verify(Base64.getDecoder().decode(sign));
    }

    public static String sign64(String method, String content, String privateKey) throws Exception {
        byte[] contentBytes = content.getBytes("utf-8");
        Signature signature = Signature.getInstance(method);
        byte[] encodedKey = Base64.getDecoder().decode(privateKey);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey priKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
        signature.initSign(priKey);
        signature.update(contentBytes);
        byte[] signs = signature.sign();
        return Base64.getEncoder().encodeToString(signs);
    }

    public static boolean verify16(String method, String content, String sign, String publicKey) throws Exception {
        byte[] contentBytes = content.getBytes("utf-8");
        Signature signature = Signature.getInstance(method);
        byte[] encodedKey = Hex.decodeHex((char[])publicKey.toCharArray());
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey pubKey = keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
        signature.initVerify(pubKey);
        signature.update(contentBytes);
        return signature.verify(Hex.decodeHex((char[])sign.toCharArray()));
    }

    public static String sign16(String method, String content, String privateKey) throws Exception {
        byte[] contentBytes = content.getBytes("utf-8");
        Signature signature = Signature.getInstance(method);
        byte[] encodedKey = Hex.decodeHex((char[])privateKey.toCharArray());
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey priKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
        signature.initSign(priKey);
        signature.update(contentBytes);
        byte[] signs = signature.sign();
        return Hex.encodeHexString((byte[])signs);
    }
}

