/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.local.flow.core.utils;

import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;

public class HmacSignUtil {
    public static final String CODE_HEX = "HEX";
    public static final String CODE_BASE64 = "BASE64";
    private static ThreadLocal<Mac> localMac = new ThreadLocal();
    public static final String METHOD_HMACSHA1 = "HmacSHA1";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sign(String method, String content, String privateKey, String codeType) throws Exception {
        SecretKeySpec keySpec = new SecretKeySpec(privateKey.getBytes(), method);
        localMac.set(Mac.getInstance(method));
        localMac.get().init(keySpec);
        try {
            if (CODE_HEX.equals(codeType)) {
                String string = Hex.encodeHexString((byte[])localMac.get().doFinal(content.getBytes()));
                return string;
            }
            if (CODE_BASE64.equals(codeType)) {
                String string = Base64.getEncoder().encodeToString(localMac.get().doFinal(content.getBytes()));
                return string;
            }
            String string = Hex.encodeHexString((byte[])localMac.get().doFinal(content.getBytes()));
            return string;
        }
        finally {
            localMac.remove();
        }
    }
}

