/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.oss.core;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.utils.DateUtil;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.DeleteObjectsResult;
import com.aliyun.oss.model.GenericRequest;
import com.aliyun.oss.model.LifecycleRule;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectResult;
import com.aliyun.oss.model.SetBucketLifecycleRequest;
import com.esotericsoftware.kryo.io.ByteBufferInputStream;
import com.xforceplus.apollo.msg.SealedMessage;
import com.xforceplus.apollo.oss.config.OssConfig;
import com.xforceplus.apollo.oss.exception.DisableException;
import com.xforceplus.apollo.oss.exception.NoSuchPropException;
import com.xforceplus.apollo.oss.exception.OssException;
import com.xforceplus.apollo.oss.exception.OssPoolException;
import com.xforceplus.apollo.oss.model.ApolloOssObject;
import com.xforceplus.apollo.oss.model.FetchKeysResult;
import com.xforceplus.apollo.oss.model.OssStringModel;
import com.xforceplus.apollo.oss.utils.MD5Helper;
import com.xforceplus.apollo.utils.DateFormatUtil;
import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.apollo.utils.FileBytesUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.apollo.utils.KyroUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ApolloOssClient {
    private String bucketName;
    private static Logger logger = LoggerFactory.getLogger(ApolloOssClient.class);
    private static volatile ApolloOssClient apolloOssClient;
    private Vector<ApolloOssObject> clients_pool = new Vector();
    private String endpoint;
    private String accessKeyId;
    private String accessKeySecret;
    public static String keyPrefix_tmp;
    private static String keyPrefix_forever;
    private List<Integer> checkTimes = new ArrayList<Integer>();

    private ApolloOssClient() throws NoSuchPropException {
        this.endpoint = OssConfig.getConfig().getProperty("aliyun.oss.endpoint");
        this.accessKeyId = OssConfig.getConfig().getProperty("aliyun.oss.accessKeyId");
        this.accessKeySecret = OssConfig.getConfig().getProperty("aliyun.oss.accessKeySecret");
        this.bucketName = OssConfig.getConfig().getProperty("aliyun.oss.bucketName");
        keyPrefix_tmp = OssConfig.getConfig().getProperty("aliyun.oss.tmp.prefix", "tmp_");
        keyPrefix_forever = OssConfig.getConfig().getProperty("aliyun.oss.forever.prefix", "forever_");
        if (StringUtils.isBlank((CharSequence)this.endpoint)) {
            throw new NoSuchPropException("aliyun.oss.endpoint \u672a\u914d\u7f6e");
        }
        if (StringUtils.isBlank((CharSequence)this.accessKeyId)) {
            throw new NoSuchPropException("aliyun.oss.accessKeyId \u672a\u914d\u7f6e");
        }
        if (StringUtils.isBlank((CharSequence)this.accessKeySecret)) {
            throw new NoSuchPropException("aliyun.oss.accessKeySecret \u672a\u914d\u7f6e");
        }
        if (StringUtils.isBlank((CharSequence)this.bucketName)) {
            throw new NoSuchPropException("aliyun.oss.bucketName \u672a\u914d\u7f6e");
        }
        int minClients = OssConfig.getConfig().getIntProperty("aliyun.oss.minClients", 1);
        if (minClients > 1) {
            for (int i = 0; i < minClients; ++i) {
                this.clients_pool.add(new ApolloOssObject(new OSSClient(this.endpoint, this.accessKeyId, this.accessKeySecret)));
            }
        } else {
            this.clients_pool.add(new ApolloOssObject(new OSSClient(this.endpoint, this.accessKeyId, this.accessKeySecret)));
        }
        this.monitor();
    }

    private synchronized OSSClient ossClient() throws OssException {
        if (CollectionUtils.isEmpty(this.clients_pool)) {
            throw new OssPoolException("OSS CLIENT POOL INIT FAILED");
        }
        OSSClient ossClient = this.getFreeOssClient();
        if (null == ossClient) {
            int maxClients = OssConfig.getConfig().getIntProperty("aliyun.oss.maxClients", 5);
            int failOver = OssConfig.getConfig().getIntProperty("aliyun.oss.failOver", 2);
            long failOverMill = OssConfig.getConfig().getLongProperty("aliyun.oss.failOverMill", 100L);
            if (this.clients_pool.size() + 1 <= maxClients) {
                ApolloOssObject ossObject = new ApolloOssObject(new OSSClient(this.endpoint, this.accessKeyId, this.accessKeySecret));
                ossObject.setBusy(true);
                ossClient = ossObject.getOssClient();
                this.clients_pool.add(ossObject);
            } else if (failOver > 0) {
                for (int i = 0; i < failOver; ++i) {
                    this.waitMoment(failOverMill);
                    ossClient = this.getFreeOssClient();
                    if (null != ossClient) break;
                }
                if (null == ossClient) {
                    ossClient = new OSSClient(this.endpoint, this.accessKeyId, this.accessKeySecret);
                }
            } else {
                throw new OssPoolException("OSS CLIENT POOL NO FREE");
            }
        }
        return ossClient;
    }

    private void revertOssClient(OSSClient ossClient) {
        Enumeration<ApolloOssObject> enumerate = this.clients_pool.elements();
        boolean isNotInPools = true;
        while (enumerate.hasMoreElements()) {
            ApolloOssObject apolloOssObject = enumerate.nextElement();
            if (ossClient != apolloOssObject.getOssClient()) continue;
            apolloOssObject.setBusy(false);
            isNotInPools = false;
            break;
        }
        if (isNotInPools && null != ossClient) {
            ossClient.shutdown();
        }
    }

    private void waitMoment(Long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException e) {
            logger.error(ErrorUtil.holdExceptionMsg((Exception)e));
        }
    }

    private OSSClient getFreeOssClient() {
        OSSClient ossClient = null;
        Enumeration<ApolloOssObject> enumerate = this.clients_pool.elements();
        while (enumerate.hasMoreElements()) {
            ApolloOssObject apolloOssObject = enumerate.nextElement();
            if (apolloOssObject.isBusy()) continue;
            apolloOssObject.setBusy(true);
            ossClient = apolloOssObject.getOssClient();
            break;
        }
        return ossClient;
    }

    private static void shutdownAll() {
        try {
            Enumeration<ApolloOssObject> enumerate = ApolloOssClient.apolloOssClient.clients_pool.elements();
            while (enumerate.hasMoreElements()) {
                ApolloOssObject apolloOssObject = enumerate.nextElement();
                if (null == apolloOssObject) continue;
                apolloOssObject.getOssClient().shutdown();
            }
        }
        catch (Exception e) {
            logger.error(ErrorUtil.holdExceptionMsg((Exception)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static ApolloOssClient getInstance() throws OssException {
        if ("false".equalsIgnoreCase(OssConfig.getConfig().getProperty("aliyun.oss.enable", "false"))) {
            if (null == apolloOssClient) throw new DisableException("oss \u529f\u80fd\u672a\u5f00\u542f");
            if (CollectionUtils.isNotEmpty(ApolloOssClient.apolloOssClient.clients_pool)) {
                ApolloOssClient.shutdownAll();
            }
            apolloOssClient = null;
            throw new DisableException("oss \u529f\u80fd\u672a\u5f00\u542f");
        }
        if (null != apolloOssClient) return apolloOssClient;
        Class<ApolloOssClient> clazz = ApolloOssClient.class;
        synchronized (ApolloOssClient.class) {
            if (null != apolloOssClient) return apolloOssClient;
            apolloOssClient = new ApolloOssClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return apolloOssClient;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean putObject(String key, String data) throws ClientException {
        OSSClient ossClient = null;
        boolean flag = false;
        try {
            ossClient = this.ossClient();
            String os = KyroUtil.serializationObject((Serializable)((Object)data));
            PutObjectResult result = ossClient.putObject(this.bucketName, key, (InputStream)new ByteBufferInputStream(ByteBuffer.wrap(os.getBytes())));
            logger.info("putObject:" + JacksonUtil.getInstance().toJson((Object)result));
            if (null != result && StringUtils.isNotBlank((CharSequence)result.getETag())) {
                flag = true;
            }
        }
        finally {
            if (null != ossClient) {
                this.revertOssClient(ossClient);
            }
        }
        return flag;
    }

    protected boolean doesBucketExist() throws ClientException {
        OSSClient ossClient = new OSSClient(this.endpoint, this.accessKeyId, this.accessKeySecret);
        try {
            if (null != ossClient) {
                boolean bl = ossClient.doesBucketExist(this.bucketName);
                return bl;
            }
        }
        finally {
            if (null != ossClient) {
                ossClient.shutdown();
            }
        }
        return false;
    }

    protected void batchPutSealedMessage(List<SealedMessage> messageList) {
        if (CollectionUtils.isEmpty(messageList)) {
            return;
        }
        this.doBatch(messageList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBatch(List<SealedMessage> messageList) {
        OSSClient ossClient = null;
        try {
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put("lifecycle", keyPrefix_tmp);
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setObjectTagging(tags);
            ossClient = this.ossClient();
            for (SealedMessage mes : messageList) {
                String key = MD5Helper.encrypt16(mes.getHeader().getMsgId());
                key = MD5Helper.encrypt16(mes.getHeader().getRequestName() + "_" + key);
                String dataJson = KyroUtil.serializationObject((Serializable)mes);
                PutObjectResult result = ossClient.putObject(this.bucketName, key, (InputStream)new ByteBufferInputStream(ByteBuffer.wrap(dataJson.getBytes())), metadata);
                logger.info("putObject-batch-tagId{},key{}", (Object)result.getRequestId(), (Object)key);
            }
            if (null != ossClient) {
                this.revertOssClient(ossClient);
            }
        }
        catch (Throwable throwable) {
            if (null != ossClient) {
                this.revertOssClient(ossClient);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doSingleString(OssStringModel stringModel) {
        OSSClient ossClient = null;
        long s = System.currentTimeMillis();
        try {
            ossClient = this.ossClient();
            if (StringUtils.isNotBlank((CharSequence)stringModel.getKey()) && StringUtils.isNotBlank((CharSequence)stringModel.getContent())) {
                ObjectMetadata metadata = new ObjectMetadata();
                metadata.getUserMetadata().put("datalen", stringModel.getLen() + "");
                metadata.getUserMetadata().put("datastring", "true");
                String ct = stringModel.getContent();
                if (stringModel.getLen() >= 2048) {
                    byte[] bytes = FileBytesUtil.jzlib((byte[])stringModel.getContent().getBytes());
                    ct = FileBytesUtil.bytesToHexString((byte[])bytes);
                    metadata.getUserMetadata().put("datazip", "true");
                }
                String dataJson = KyroUtil.serializationObject((Serializable)((Object)ct));
                PutObjectResult result = ossClient.putObject(this.bucketName, stringModel.getKey(), (InputStream)new ByteBufferInputStream(ByteBuffer.wrap(dataJson.getBytes())), metadata);
                if (null != result) {
                    logger.info("putObject-batch-tagId{},key{}-times:{}", new Object[]{result.getRequestId(), stringModel.getKey(), System.currentTimeMillis() - s});
                    boolean bl = true;
                    return bl;
                }
                logger.info("putObject-batch-tagId{},key{}", (Object)"nil", (Object)stringModel.getKey());
            }
        }
        finally {
            if (null != ossClient) {
                this.revertOssClient(ossClient);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doBatchString(List<OssStringModel> messageList) {
        OSSClient ossClient = null;
        long s = System.currentTimeMillis();
        try {
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put("lifecycle", keyPrefix_tmp);
            ossClient = this.ossClient();
            for (OssStringModel mes : messageList) {
                if (!StringUtils.isNotBlank((CharSequence)mes.getKey())) continue;
                if (StringUtils.isNotBlank((CharSequence)mes.getContent())) {
                    try {
                        PutObjectResult result;
                        ObjectMetadata metadata = new ObjectMetadata();
                        metadata.getUserMetadata().put("datalen", mes.getLen() + "");
                        metadata.getUserMetadata().put("datastring", "true");
                        String ct = mes.getContent();
                        if (mes.getLen() >= 2048) {
                            byte[] bytes = FileBytesUtil.jzlib((byte[])mes.getContent().getBytes());
                            ct = FileBytesUtil.bytesToHexString((byte[])bytes);
                            metadata.getUserMetadata().put("datazip", "true");
                        }
                        String dataJson = KyroUtil.serializationObject((Serializable)((Object)ct));
                        if (mes.getKey().startsWith(keyPrefix_tmp)) {
                            metadata.setObjectTagging(tags);
                            result = ossClient.putObject(this.bucketName, mes.getKey().replace(keyPrefix_tmp, ""), (InputStream)new ByteBufferInputStream(ByteBuffer.wrap(dataJson.getBytes())), metadata);
                        } else {
                            result = ossClient.putObject(this.bucketName, mes.getKey(), (InputStream)new ByteBufferInputStream(ByteBuffer.wrap(dataJson.getBytes())), metadata);
                        }
                        if (null != result) {
                            logger.info("putObject-batch-tagId{},key{}-times:{}", new Object[]{result.getRequestId(), mes.getKey(), System.currentTimeMillis() - s});
                            continue;
                        }
                        logger.info("putObject-batch-tagId{},key{}", (Object)"nil", (Object)mes.getKey());
                    }
                    catch (Exception e) {
                        logger.error("OSS {}\u6279\u91cf\u4fdd\u5b58\u5f02\u5e38:{}", (Object)mes.getKey(), (Object)e);
                    }
                    continue;
                }
                if (mes.getKey().startsWith(keyPrefix_tmp)) {
                    try {
                        this.removeObject(mes.getKey().replace(keyPrefix_tmp, ""));
                    }
                    catch (Exception e) {
                        logger.error("OSS {}\u5220\u9664\u5f02\u5e38:{}", (Object)mes.getKey().replace(keyPrefix_tmp, ""), (Object)e);
                    }
                }
                try {
                    this.removeObject(mes.getKey());
                }
                catch (Exception e) {
                    logger.error("OSS {}\u5220\u9664\u5f02\u5e38:{}", (Object)mes.getKey(), (Object)e);
                }
            }
            if (null != ossClient) {
                this.revertOssClient(ossClient);
            }
        }
        catch (Throwable throwable) {
            if (null != ossClient) {
                this.revertOssClient(ossClient);
            }
            throw throwable;
        }
    }

    protected SealedMessage fetchSealedMessage(String key, boolean isUnzip) throws ClientException {
        if (isUnzip) {
            return this.fetchSealedMessage(key);
        }
        String jsonData = this.fetchPrefixObject(key);
        if (StringUtils.isBlank((CharSequence)jsonData)) {
            return null;
        }
        return (SealedMessage)KyroUtil.deserializationObject((String)jsonData, SealedMessage.class);
    }

    protected SealedMessage fetchSealedMessage(String key) throws ClientException {
        byte[] oriBytes;
        byte[] compressBytes;
        String hexString;
        String jsonData = this.fetchPrefixObject(key);
        if (StringUtils.isBlank((CharSequence)jsonData)) {
            return null;
        }
        SealedMessage item = (SealedMessage)KyroUtil.deserializationObject((String)jsonData, SealedMessage.class);
        if (null == item) {
            return null;
        }
        if ("true".equals(item.getHeader().getOthers().get("bigDataCompress")) && null != item.getPayload() && null != item.getPayload().getObj() && StringUtils.isNotBlank((CharSequence)(hexString = item.getPayload().getObj().toString())) && null != (compressBytes = FileBytesUtil.hexStringToByte((String)hexString)) && compressBytes.length > 0 && null != (oriBytes = FileBytesUtil.unjzlib((byte[])compressBytes)) && oriBytes.length > 0) {
            String oriString = new String(oriBytes);
            item.getHeader().getOthers().remove("bigDataCompress");
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)item.getHeader().getOthers().get("clazzName")))) {
                try {
                    Class<?> clazz = Class.forName((String)item.getHeader().getOthers().get("clazzName"));
                    item = new SealedMessage(item.getHeader(), new SealedMessage.Payload(JacksonUtil.getInstance().fromJson(oriString, clazz)));
                    item.getHeader().getOthers().remove("clazzName");
                }
                catch (ClassNotFoundException e) {
                    item = new SealedMessage(item.getHeader(), new SealedMessage.Payload((Object)oriString));
                }
            } else {
                item = new SealedMessage(item.getHeader(), new SealedMessage.Payload((Object)oriString));
            }
        }
        return item;
    }

    protected String fetchPrefixObject(String key) throws ClientException {
        String jsonData = this.fetchObject(key);
        if (StringUtils.isBlank((CharSequence)jsonData)) {
            jsonData = this.fetchObject(keyPrefix_tmp + key);
        }
        if (StringUtils.isBlank((CharSequence)jsonData) && Objects.equals(OssConfig.getConfig().getProperty("aliyun.oss.need.prefix", "false"), "false")) {
            jsonData = this.fetchObject(key);
        }
        if (StringUtils.isBlank((CharSequence)jsonData)) {
            return null;
        }
        return jsonData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String fetchObject(String key) throws ClientException {
        byte[] oriBytes;
        byte[] compressBytes;
        BufferedReader reader = null;
        StringBuilder sb = new StringBuilder();
        OSSClient ossClient = null;
        boolean dataCompress = false;
        try {
            String line;
            ossClient = this.ossClient();
            OSSObject ossObject = ossClient.getObject(this.bucketName, key);
            if (null == ossObject || null == ossObject.getObjectContent()) {
                String string = null;
                return string;
            }
            if (null != ossObject.getObjectMetadata() && null != ossObject.getObjectMetadata().getUserMetadata()) {
                dataCompress = Objects.equals("true", ossObject.getObjectMetadata().getUserMetadata().get("datazip"));
            }
            reader = new BufferedReader(new InputStreamReader(ossObject.getObjectContent()));
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (Exception e) {
            logger.error(ErrorUtil.getStackMsg((Exception)e));
            String line = null;
            return line;
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.error(ErrorUtil.holdExceptionMsg((Exception)e));
                }
            }
            if (null != ossClient) {
                this.revertOssClient(ossClient);
            }
        }
        if (dataCompress && sb.length() > 0 && null != (compressBytes = FileBytesUtil.hexStringToByte((String)((String)((Object)KyroUtil.deserializationObject((String)sb.toString(), String.class))))) && compressBytes.length > 0 && null != (oriBytes = FileBytesUtil.unjzlib((byte[])compressBytes)) && oriBytes.length > 0) {
            return KyroUtil.serializationObject((Serializable)((Object)new String(oriBytes)));
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeObject(String key) throws ClientException {
        OSSClient ossClient = null;
        try {
            ossClient = this.ossClient();
            ossClient.deleteObject(this.bucketName, key);
            boolean bl = true;
            return bl;
        }
        finally {
            if (null != ossClient) {
                this.revertOssClient(ossClient);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> removeBatchObject(List<String> keys) throws ClientException {
        OSSClient ossClient = null;
        try {
            ossClient = this.ossClient();
            DeleteObjectsResult deleteObjectsResult = ossClient.deleteObjects(new DeleteObjectsRequest(this.bucketName).withKeys(keys));
            List list = deleteObjectsResult.getDeletedObjects();
            return list;
        }
        finally {
            if (null != ossClient) {
                this.revertOssClient(ossClient);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isObjectExist(String key) throws ClientException {
        OSSClient ossClient = null;
        try {
            ossClient = this.ossClient();
            boolean bl = ossClient.doesObjectExist(this.bucketName, key);
            return bl;
        }
        finally {
            if (null != ossClient) {
                this.revertOssClient(ossClient);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lifecycle(String ruleId, String matchPrefix, int days) throws ClientException {
        OSSClient ossClient = null;
        try {
            List<LifecycleRule> lifecycleRules = this.showLifecycle();
            if (null == lifecycleRules) {
                lifecycleRules = new ArrayList<LifecycleRule>();
            }
            ossClient = this.ossClient();
            SetBucketLifecycleRequest request = new SetBucketLifecycleRequest(this.bucketName);
            lifecycleRules.add(new LifecycleRule(ruleId, matchPrefix, LifecycleRule.RuleStatus.Enabled, days));
            request.setLifecycleRules(lifecycleRules);
            ossClient.setBucketLifecycle(request);
            if (null != ossClient) {
                this.revertOssClient(ossClient);
            }
        }
        catch (Throwable throwable) {
            if (null != ossClient) {
                this.revertOssClient(ossClient);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lifecycle(String ruleId, String matchPrefix, Date date) throws ClientException, ParseException {
        OSSClient ossClient = null;
        try {
            List<LifecycleRule> lifecycleRules = this.showLifecycle();
            if (null == lifecycleRules) {
                lifecycleRules = new ArrayList<LifecycleRule>();
            }
            ossClient = this.ossClient();
            SetBucketLifecycleRequest request = new SetBucketLifecycleRequest(this.bucketName);
            LifecycleRule rule = new LifecycleRule(ruleId, matchPrefix, LifecycleRule.RuleStatus.Enabled);
            rule.setCreatedBeforeDate(DateUtil.parseIso8601Date((String)String.format("%sT00:00:00.000Z", DateFormatUtil.getDateStr((Date)date))));
            request.setLifecycleRules(lifecycleRules);
            lifecycleRules.add(rule);
            ossClient.setBucketLifecycle(request);
            if (null != ossClient) {
                this.revertOssClient(ossClient);
            }
        }
        catch (Throwable throwable) {
            if (null != ossClient) {
                this.revertOssClient(ossClient);
            }
            throw throwable;
        }
    }

    protected List<LifecycleRule> showLifecycle() throws ClientException {
        OSSClient ossClient = null;
        try {
            ossClient = this.ossClient();
            List list = ossClient.getBucketLifecycle(this.bucketName);
            return list;
        }
        finally {
            if (null != ossClient) {
                this.revertOssClient(ossClient);
            }
        }
    }

    protected void clearLifecycle(String ruleId) throws ClientException {
        OSSClient ossClient = null;
        try {
            ossClient = this.ossClient();
            if (StringUtils.isBlank((CharSequence)ruleId)) {
                ossClient.deleteBucketLifecycle(this.bucketName);
            } else {
                ossClient.deleteBucketLifecycle(new GenericRequest(this.bucketName, ruleId));
            }
        }
        finally {
            if (null != ossClient) {
                this.revertOssClient(ossClient);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FetchKeysResult fetchKeyList(String keyPrefix, Integer rows) throws ClientException {
        OSSClient ossClient = null;
        ArrayList<String> keys = new ArrayList<String>();
        try {
            ossClient = this.ossClient();
            ObjectListing objectListing = ossClient.listObjects(new ListObjectsRequest(this.bucketName).withMaxKeys(rows).withPrefix(keyPrefix));
            List sums = objectListing.getObjectSummaries();
            for (OSSObjectSummary s : sums) {
                keys.add(s.getKey());
            }
            FetchKeysResult fetchKeysResult = new FetchKeysResult(keys);
            return fetchKeysResult;
        }
        finally {
            if (null != ossClient) {
                this.revertOssClient(ossClient);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FetchKeysResult fetchKeyList(String keyPrefix, Integer rows, String marker) throws ClientException {
        OSSClient ossClient = null;
        ArrayList<String> keys = new ArrayList<String>();
        try {
            if (null == rows) {
                rows = 100;
            }
            if (rows > 1000) {
                rows = 1000;
            }
            ossClient = this.ossClient();
            ObjectListing objectListing = ossClient.listObjects(new ListObjectsRequest(this.bucketName).withMaxKeys(rows).withPrefix(keyPrefix).withMarker(marker));
            List sums = objectListing.getObjectSummaries();
            for (OSSObjectSummary s : sums) {
                keys.add(s.getKey());
            }
            FetchKeysResult fetchKeysResult = new FetchKeysResult(objectListing.getNextMarker(), keys);
            if (null != ossClient) {
                this.revertOssClient(ossClient);
            }
            return fetchKeysResult;
        }
        catch (Throwable throwable) {
            if (null != ossClient) {
                this.revertOssClient(ossClient);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String uploadFile(InputStream inputStream, String fileName, String fileType, String key) throws IOException {
        OSSClient ossClient = null;
        try {
            ossClient = this.ossClient();
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setContentLength((long)inputStream.available());
            objectMetadata.setCacheControl("no-cache");
            objectMetadata.setHeader("Pragma", (Object)"no-cache");
            objectMetadata.setContentType(ApolloOssClient.getContentType(fileType));
            objectMetadata.setContentDisposition("inline;filename=" + fileName);
            PutObjectResult putResult = ossClient.putObject(this.bucketName, key, inputStream, objectMetadata);
            if (null != putResult && StringUtils.isNotBlank((CharSequence)putResult.getETag())) {
                String string = key;
                return string;
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                logger.error(ErrorUtil.getStackMsg((Exception)e));
            }
            if (null != ossClient) {
                this.revertOssClient(ossClient);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OSSObject getOssObj(String ossKey) {
        OSSClient ossClient = null;
        OSSObject ossObj = null;
        try {
            ossClient = this.ossClient();
            ossObj = ossClient.getObject(this.bucketName, ossKey);
        }
        finally {
            if (null != ossClient) {
                this.revertOssClient(ossClient);
            }
        }
        return ossObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getUrl(String key) {
        OSSClient ossClient = null;
        try {
            ossClient = this.ossClient();
            Date expiration = new Date(System.currentTimeMillis() + 31536000000L);
            URL url = ossClient.generatePresignedUrl(this.bucketName, key, expiration);
            if (url != null) {
                String string = String.format("%s://%s%s", url.getProtocol(), url.getHost(), url.getPath());
                return string;
            }
        }
        finally {
            if (null != ossClient) {
                this.revertOssClient(ossClient);
            }
        }
        return null;
    }

    private static String getContentType(String filenameExtension) {
        if (filenameExtension.equalsIgnoreCase("bmp")) {
            return "image/bmp";
        }
        if (filenameExtension.equalsIgnoreCase("gif")) {
            return "image/gif";
        }
        if (filenameExtension.equalsIgnoreCase("jpeg") || filenameExtension.equalsIgnoreCase("jpg") || filenameExtension.equalsIgnoreCase("png")) {
            return "image/jpeg";
        }
        if (filenameExtension.equalsIgnoreCase("html")) {
            return "text/html";
        }
        if (filenameExtension.equalsIgnoreCase("txt")) {
            return "text/plain";
        }
        if (filenameExtension.equalsIgnoreCase("vsd")) {
            return "application/vnd.visio";
        }
        if (filenameExtension.equalsIgnoreCase("pptx") || filenameExtension.equalsIgnoreCase("ppt")) {
            return "application/vnd.ms-powerpoint";
        }
        if (filenameExtension.equalsIgnoreCase("docx") || filenameExtension.equalsIgnoreCase("doc")) {
            return "application/msword";
        }
        if (filenameExtension.equalsIgnoreCase("xml")) {
            return "text/xml";
        }
        if (filenameExtension.equalsIgnoreCase("mp4")) {
            return "video/mp4";
        }
        if (filenameExtension.equalsIgnoreCase(".avi")) {
            return "video/avi";
        }
        if (filenameExtension.equalsIgnoreCase(".qsv")) {
            return "video/qsv";
        }
        return "image/jpeg";
    }

    private void monitor() {
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                block12: {
                    logger.info("<<<<<<<<<<<<<<<active>>>>>>>>>:" + apolloOssClient.clients_pool.size());
                    try {
                        if (CollectionUtils.isNotEmpty((Collection)ApolloOssClient.this.checkTimes) && ApolloOssClient.this.checkTimes.size() >= 5) {
                            int minClients = OssConfig.getConfig().getIntProperty("aliyun.oss.minClients", 5);
                            int freeCount = ApolloOssClient.this.freeCount();
                            boolean isReBack = false;
                            int len = ApolloOssClient.this.checkTimes.size();
                            for (int i = 0; i < len; ++i) {
                                int val = (Integer)ApolloOssClient.this.checkTimes.get(i);
                                if (freeCount - val <= minClients * 2) continue;
                                isReBack = true;
                            }
                            if (isReBack) {
                                Enumeration enumerate = apolloOssClient.clients_pool.elements();
                                ArrayList<ApolloOssObject> list = new ArrayList<ApolloOssObject>();
                                block4: for (int i = 0; i < minClients; ++i) {
                                    while (enumerate.hasMoreElements()) {
                                        ApolloOssObject apolloOssObject = (ApolloOssObject)enumerate.nextElement();
                                        if (apolloOssObject.isBusy()) continue;
                                        apolloOssObject.setBusy(true);
                                        list.add(apolloOssObject);
                                        continue block4;
                                    }
                                }
                                if (list.size() == minClients) {
                                    for (ApolloOssObject ossObj : list) {
                                        ossObj.getOssClient().shutdown();
                                        apolloOssClient.clients_pool.remove(ossObj);
                                    }
                                } else {
                                    for (ApolloOssObject ossObj : list) {
                                        ApolloOssClient.this.revertOssClient(ossObj.getOssClient());
                                    }
                                }
                                list.clear();
                            }
                            ApolloOssClient.this.checkTimes.clear();
                            break block12;
                        }
                        ApolloOssClient.this.checkTimes.add(ApolloOssClient.this.freeCount());
                    }
                    catch (Exception e) {
                        logger.error(ErrorUtil.holdExceptionMsg((Exception)e));
                    }
                    catch (Error error) {
                        logger.error(ErrorUtil.holdExceptionMsg((Throwable)error));
                    }
                }
            }
        }, 50L, 30000L);
    }

    private Integer freeCount() {
        Enumeration<ApolloOssObject> enumerate = ApolloOssClient.apolloOssClient.clients_pool.elements();
        int count = 0;
        while (enumerate.hasMoreElements()) {
            ApolloOssObject apolloOssObject = enumerate.nextElement();
            if (apolloOssObject.isBusy()) continue;
            ++count;
        }
        return count;
    }

    static {
        keyPrefix_tmp = "tmp_";
        keyPrefix_forever = "forever_";
    }
}

