/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.oss.core;

import com.xforceplus.apollo.oss.config.OssConfig;
import com.xforceplus.apollo.oss.core.ApolloOssClient;
import com.xforceplus.apollo.utils.ErrorUtil;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApolloOssHelper {
    private static Logger LOGGER = LoggerFactory.getLogger(ApolloOssHelper.class);
    private ExecutorService PUT_EXECUTOR_SERVICE = new ThreadPoolExecutor(1, OssConfig.getConfig().getIntProperty("oss.send.thread.max", 10), 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    private static volatile ApolloOssHelper apolloOssHelper;

    private ApolloOssHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static ApolloOssHelper getInstance() {
        if (null != apolloOssHelper) return apolloOssHelper;
        Class<ApolloOssClient> clazz = ApolloOssClient.class;
        synchronized (ApolloOssClient.class) {
            if (null != apolloOssHelper) return apolloOssHelper;
            apolloOssHelper = new ApolloOssHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return apolloOssHelper;
        }
    }

    public void execute(Runnable command) {
        try {
            this.PUT_EXECUTOR_SERVICE.execute(command);
        }
        catch (Exception e) {
            LOGGER.error(ErrorUtil.holdExceptionMsg((Exception)e));
        }
    }

    public void shutdown() {
        try {
            this.PUT_EXECUTOR_SERVICE.shutdown();
            this.PUT_EXECUTOR_SERVICE.awaitTermination(1L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.error(ErrorUtil.holdExceptionMsg((Exception)e));
        }
    }
}

