/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.oss.core;

import com.aliyun.oss.model.OSSObject;
import com.xforceplus.apollo.msg.SealedMessage;
import com.xforceplus.apollo.oss.config.OssConfig;
import com.xforceplus.apollo.oss.core.ApolloOssClient;
import com.xforceplus.apollo.oss.core.ApolloOssHelper;
import com.xforceplus.apollo.oss.core.BusinessStringTask;
import com.xforceplus.apollo.oss.core.BusinessTask;
import com.xforceplus.apollo.oss.exception.OssDisableException;
import com.xforceplus.apollo.oss.model.OssStringModel;
import com.xforceplus.apollo.oss.utils.MD5Helper;
import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.apollo.utils.KyroUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApolloOssServe {
    private static Logger LOGGER = LoggerFactory.getLogger(ApolloOssServe.class);
    private static volatile ApolloOssServe apolloOssServe;
    private static BlockingQueue<SealedMessage> QUEUE;
    private static BlockingQueue<OssStringModel> QUEUE_STRING;

    private ApolloOssServe() {
        int i;
        QUEUE = new LinkedBlockingQueue<SealedMessage>(OssConfig.getConfig().getIntProperty("oss.send.queue.size", 2048));
        QUEUE_STRING = new LinkedBlockingQueue<OssStringModel>(OssConfig.getConfig().getIntProperty("oss.send.queue.string.size", 512));
        int cc = OssConfig.getConfig().getIntProperty("oss.send.thread.size", 4);
        int cs = OssConfig.getConfig().getIntProperty("oss.send.thread.string.size", 4);
        for (i = 0; i < cc; ++i) {
            ApolloOssHelper.getInstance().execute(new BusinessTask());
        }
        for (i = 0; i < cs; ++i) {
            ApolloOssHelper.getInstance().execute(new BusinessStringTask());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApolloOssServe getInstance() {
        if (null != apolloOssServe) return apolloOssServe;
        Class<ApolloOssServe> clazz = ApolloOssServe.class;
        synchronized (ApolloOssServe.class) {
            if (null != apolloOssServe) return apolloOssServe;
            apolloOssServe = new ApolloOssServe();
            // ** MonitorExit[var0] (shouldn't be in output)
            return apolloOssServe;
        }
    }

    public void drainTo(List<SealedMessage> items, int size) {
        QUEUE.drainTo(items, size);
    }

    public SealedMessage take() {
        try {
            return QUEUE.take();
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public void drainToString(List<OssStringModel> items, int size) {
        QUEUE_STRING.drainTo(items, size);
    }

    public OssStringModel takeToString() {
        try {
            return QUEUE_STRING.take();
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public boolean put2oss(SealedMessage message) throws OssDisableException {
        if ("false".equalsIgnoreCase(OssConfig.getConfig().getProperty("aliyun.oss.enable", "false"))) {
            LOGGER.warn("OSS service is disable by some one,please check the oss.properties");
            return false;
        }
        boolean b = QUEUE.offer(message);
        LOGGER.info("put queue result:" + b);
        return true;
    }

    public SealedMessage get4oss(String key) throws OssDisableException, IOException {
        if (StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        String md5Key = MD5Helper.encrypt16(key);
        SealedMessage sealedMessage = ApolloOssClient.getInstance().fetchSealedMessage(md5Key);
        if (null == sealedMessage) {
            sealedMessage = ApolloOssClient.getInstance().fetchSealedMessage(key);
        }
        return sealedMessage;
    }

    public SealedMessage get4oss(String key, boolean isUnzip) throws OssDisableException, IOException {
        if (StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        String md5Key = MD5Helper.encrypt16(key);
        SealedMessage sealedMessage = ApolloOssClient.getInstance().fetchSealedMessage(md5Key, isUnzip);
        if (null == sealedMessage) {
            sealedMessage = ApolloOssClient.getInstance().fetchSealedMessage(key, isUnzip);
        }
        return sealedMessage;
    }

    public boolean put2oss(String key, String message) throws OssDisableException {
        if ("false".equalsIgnoreCase(OssConfig.getConfig().getProperty("aliyun.oss.enable", "false"))) {
            LOGGER.warn("OSS service is disable by some one,please check the oss.properties");
            return false;
        }
        int len = 0;
        if (StringUtils.isNotBlank((CharSequence)message)) {
            try {
                len = message.getBytes("UTF-8").length;
            }
            catch (Exception e) {
                LOGGER.error(ErrorUtil.getStackMsg((Exception)e));
            }
        }
        return QUEUE_STRING.offer(new OssStringModel(key, message, len));
    }

    public String fetch4oss(String key) throws OssDisableException, IOException {
        String data;
        String newKey = null;
        if (key.startsWith(ApolloOssClient.keyPrefix_tmp)) {
            newKey = key.replace(ApolloOssClient.keyPrefix_tmp, "");
        }
        if (StringUtils.isBlank((CharSequence)(data = ApolloOssClient.getInstance().fetchObject(newKey)))) {
            data = ApolloOssClient.getInstance().fetchObject(key);
        }
        return StringUtils.isNotBlank((CharSequence)data) ? (String)((Object)KyroUtil.deserializationObject((String)data, String.class)) : data;
    }

    public String putFile2oss(InputStream inputStream, String fileName, String fileType, String key) throws OssDisableException, IOException {
        if ("false".equalsIgnoreCase(OssConfig.getConfig().getProperty("aliyun.oss.enable", "false"))) {
            LOGGER.warn("OSS service is disable by some one,please check the oss.properties");
            return null;
        }
        return ApolloOssClient.getInstance().uploadFile(inputStream, fileName, fileType, key);
    }

    public OSSObject fetch4ossObj(String key) throws OssDisableException {
        return ApolloOssClient.getInstance().getOssObj(key);
    }

    public String fetch4ossUrl(String key) throws OssDisableException {
        return ApolloOssClient.getInstance().getUrl(key);
    }
}

