/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.oss.core;

import com.xforceplus.apollo.oss.core.ApolloOssClient;
import com.xforceplus.apollo.oss.core.ApolloOssServe;
import com.xforceplus.apollo.oss.model.OssStringModel;
import com.xforceplus.apollo.utils.ErrorUtil;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusinessStringTask
implements Runnable {
    private static Logger LOGGER = LoggerFactory.getLogger(BusinessStringTask.class);
    private List<OssStringModel> items;

    @Override
    public void run() {
        this.items = new CopyOnWriteArrayList<OssStringModel>();
        while (true) {
            try {
                OssStringModel item = ApolloOssServe.getInstance().takeToString();
                if (null == item) continue;
                ApolloOssServe.getInstance().drainToString(this.items, 50);
                if (this.items.size() < 20) {
                    TimeUnit.MILLISECONDS.sleep(100L);
                }
                this.items.add(item);
                ApolloOssClient.getInstance().doBatchString(this.items);
                continue;
            }
            catch (Exception e) {
                LOGGER.error(ErrorUtil.getStackMsg((Exception)e));
                continue;
            }
            catch (Error error) {
                LOGGER.error(ErrorUtil.getStackMsg((Throwable)error));
                continue;
            }
            finally {
                this.items.clear();
                continue;
            }
            break;
        }
    }
}

