/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.oss.core;

import java.io.Serializable;

public class Page
implements Serializable {
    private static final long serialVersionUID = 4836912765553524379L;
    public static final int PAGESIZE_DEFAULT = 10;
    public static final int CURRENTPAGE_DEFAULT = 1;
    private int pageSize = 10;
    private int currentPage = 1;
    private int totalSize;
    public static final Page _DEFAULT = new Page(0, 10);

    public Page() {
    }

    public Page(int currentPage, int pageSize) {
        this.setPageSize(pageSize);
        this.setCurrentPage(currentPage);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        if (currentPage < 1) {
            currentPage = 1;
        }
        this.currentPage = currentPage;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public void setTotalSize(int totalSize) {
        this.totalSize = totalSize;
    }

    public static int getPagesizeDefault() {
        return 10;
    }

    public int getStart() {
        return (this.currentPage - 1) * this.pageSize;
    }

    public int getLimit() {
        return this.pageSize;
    }

    public Page nextPage() {
        ++this.currentPage;
        return this;
    }

    public Page perviousPage() {
        if (this.currentPage > 1) {
            --this.currentPage;
        }
        return this;
    }

    public int getTotalPage() {
        if (this.pageSize <= 0) {
            return 1;
        }
        return (this.totalSize + this.pageSize - 1) / this.pageSize;
    }

    public String toString() {
        return String.format("Page [pageSize=%s, currentPage=%s, totalSize=%s]", this.pageSize, this.currentPage, this.totalSize);
    }
}

