/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.utils;

import java.util.Arrays;

public abstract class Base64Util {
    private static final int CHUNK_SIZE = 76;
    private static final char[] CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static final char[] URL_SAFE_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_-".toCharArray();
    private static final int[] INV = new int[256];
    private static final int[] URL_SAFE_INV = new int[256];
    private static final char PADDING = '=';
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final char[] EMPTY_CHARS = new char[0];

    public static String encodeToUrlSafeString(byte[] bytes) {
        return Base64Util.encodeToUrlSafeString(bytes, false);
    }

    public static String encodeToUrlSafeString(byte[] bytes, boolean lineSep) {
        return String.valueOf(Base64Util.encodeToChars(bytes, lineSep, true));
    }

    public static String encodeToString(byte[] bytes) {
        return Base64Util.encodeToString(bytes, false);
    }

    public static String encodeToString(byte[] bytes, boolean lineSep) {
        return new String(Base64Util.encodeToChars(bytes, lineSep));
    }

    public static char[] encodeToChars(byte[] bytes, boolean lineSeparator) {
        return Base64Util.encodeToChars(bytes, lineSeparator, false);
    }

    public static byte[] encode(byte[] bytes) {
        return Base64Util.encode(bytes, false);
    }

    public static byte[] encode(byte[] bytes, boolean lineSeparator) {
        return Base64Util.encode(bytes, lineSeparator, false);
    }

    public static char[] encodeToChars(byte[] bytes, boolean lineSeparator, boolean urlSafe) {
        int len;
        char[] TAB = urlSafe ? URL_SAFE_CHARS : CHARS;
        int n = len = bytes != null ? bytes.length : 0;
        if (len == 0) {
            return EMPTY_CHARS;
        }
        int evenlen = len / 3 * 3;
        int cnt = (len - 1) / 3 + 1 << 2;
        int destLen = cnt + (lineSeparator ? (cnt - 1) / 76 << 1 : 0);
        char[] dest = new char[destLen];
        int left = 0;
        int i = 0;
        int cc = 0;
        while (left < evenlen) {
            int i1 = (bytes[left++] & 0xFF) << 16 | (bytes[left++] & 0xFF) << 8 | bytes[left++] & 0xFF;
            dest[i++] = TAB[i1 >>> 18 & 0x3F];
            dest[i++] = TAB[i1 >>> 12 & 0x3F];
            dest[i++] = TAB[i1 >>> 6 & 0x3F];
            dest[i++] = TAB[i1 & 0x3F];
            if (!lineSeparator || ++cc != 19 || i >= destLen - 2) continue;
            dest[i++] = 13;
            dest[i++] = 10;
            cc = 0;
        }
        left = len - evenlen;
        if (left > 0) {
            i = (bytes[evenlen] & 0xFF) << 10 | (left == 2 ? (bytes[len - 1] & 0xFF) << 2 : 0);
            dest[destLen - 4] = TAB[i >> 12];
            dest[destLen - 3] = TAB[i >>> 6 & 0x3F];
            dest[destLen - 2] = left == 2 ? TAB[i & 0x3F] : 61;
            dest[destLen - 1] = 61;
        }
        return dest;
    }

    public static byte[] encode(byte[] bytes, boolean lineSep, boolean urlSafe) {
        int len;
        char[] TAB = urlSafe ? URL_SAFE_CHARS : CHARS;
        int n = len = bytes != null ? bytes.length : 0;
        if (len == 0) {
            return EMPTY_BYTES;
        }
        int evenlen = len / 3 * 3;
        int cnt = (len - 1) / 3 + 1 << 2;
        int destlen = cnt + (lineSep ? (cnt - 1) / 76 << 1 : 0);
        byte[] dest = new byte[destlen];
        int left = 0;
        int i = 0;
        int cc = 0;
        while (left < evenlen) {
            int i1 = (bytes[left++] & 0xFF) << 16 | (bytes[left++] & 0xFF) << 8 | bytes[left++] & 0xFF;
            dest[i++] = (byte)TAB[i1 >>> 18 & 0x3F];
            dest[i++] = (byte)TAB[i1 >>> 12 & 0x3F];
            dest[i++] = (byte)TAB[i1 >>> 6 & 0x3F];
            dest[i++] = (byte)TAB[i1 & 0x3F];
            if (!lineSep || ++cc != 19 || i >= destlen - 2) continue;
            dest[i++] = 13;
            dest[i++] = 10;
            cc = 0;
        }
        left = len - evenlen;
        if (left > 0) {
            i = (bytes[evenlen] & 0xFF) << 10 | (left == 2 ? (bytes[len - 1] & 0xFF) << 2 : 0);
            dest[destlen - 4] = (byte)TAB[i >> 12];
            dest[destlen - 3] = (byte)TAB[i >>> 6 & 0x3F];
            dest[destlen - 2] = left == 2 ? (int)TAB[i & 0x3F] : 61;
            dest[destlen - 1] = 61;
        }
        return dest;
    }

    public static byte[] decode(String base64) {
        return Base64Util.decode(base64, false);
    }

    public static byte[] decode(String base64, boolean urlSafe) {
        return Base64Util.decode(base64.toCharArray(), urlSafe);
    }

    public static byte[] decode(char[] base64Chars) {
        return Base64Util.decode(base64Chars, false);
    }

    public static byte[] decode(char[] base64Chars, boolean urlSafe) {
        int[] DECODE_TAB = urlSafe ? URL_SAFE_INV : INV;
        int length = base64Chars.length;
        if (length == 0) {
            return EMPTY_BYTES;
        }
        int sndx = 0;
        int endx = length - 1;
        int pad = base64Chars[endx] == '=' ? (base64Chars[endx - 1] == '=' ? 2 : 1) : 0;
        int cnt = endx - sndx + 1;
        int sepCnt = length > 76 ? (base64Chars[76] == '\r' ? cnt / 76 + 2 : 0) << 1 : 0;
        int len = ((cnt - sepCnt) * 6 >> 3) - pad;
        byte[] dest = new byte[len];
        int d = 0;
        int i = 0;
        int r = len / 3 * 3;
        while (d < r) {
            int i1 = DECODE_TAB[base64Chars[sndx++]] << 18 | DECODE_TAB[base64Chars[sndx++]] << 12 | DECODE_TAB[base64Chars[sndx++]] << 6 | DECODE_TAB[base64Chars[sndx++]];
            dest[d++] = (byte)(i1 >> 16);
            dest[d++] = (byte)(i1 >> 8);
            dest[d++] = (byte)i1;
            if (sepCnt <= 0 || ++i != 19) continue;
            sndx += 2;
            i = 0;
        }
        if (d < len) {
            i = 0;
            r = 0;
            while (sndx <= endx - pad) {
                i |= DECODE_TAB[base64Chars[sndx++]] << 18 - r * 6;
                ++r;
            }
            r = 16;
            while (d < len) {
                dest[d++] = (byte)(i >> r);
                r -= 8;
            }
        }
        return dest;
    }

    public static byte[] decode(byte[] base64Bytes) {
        return Base64Util.decode(base64Bytes, false);
    }

    public static byte[] decode(byte[] base64Bytes, boolean urlSafe) {
        int[] DECODE_TAB = urlSafe ? URL_SAFE_INV : INV;
        int length = base64Bytes.length;
        if (length == 0) {
            return EMPTY_BYTES;
        }
        int sndx = 0;
        int endx = length - 1;
        int pad = base64Bytes[endx] == 61 ? (base64Bytes[endx - 1] == 61 ? 2 : 1) : 0;
        int cnt = endx - sndx + 1;
        int sepCnt = length > 76 ? (base64Bytes[76] == 13 ? cnt / 78 : 0) << 1 : 0;
        int len = ((cnt - sepCnt) * 6 >> 3) - pad;
        byte[] dest = new byte[len];
        int d = 0;
        int i = 0;
        int r = len / 3 * 3;
        while (d < r) {
            int i1 = DECODE_TAB[base64Bytes[sndx++]] << 18 | DECODE_TAB[base64Bytes[sndx++]] << 12 | DECODE_TAB[base64Bytes[sndx++]] << 6 | DECODE_TAB[base64Bytes[sndx++]];
            dest[d++] = (byte)(i1 >> 16);
            dest[d++] = (byte)(i1 >> 8);
            dest[d++] = (byte)i1;
            if (sepCnt <= 0 || ++i != 19) continue;
            sndx += 2;
            i = 0;
        }
        if (d < len) {
            i = 0;
            r = 0;
            while (sndx <= endx - pad) {
                i |= DECODE_TAB[base64Bytes[sndx++]] << 18 - r * 6;
                ++r;
            }
            r = 16;
            while (d < len) {
                dest[d++] = (byte)(i >> r);
                r -= 8;
            }
        }
        return dest;
    }

    private Base64Util() {
    }

    static {
        Arrays.fill(INV, -1);
        int i = 0;
        int iS = CHARS.length;
        while (i < iS) {
            Base64Util.INV[Base64Util.CHARS[i]] = i++;
        }
        Base64Util.INV[61] = 0;
        Arrays.fill(URL_SAFE_INV, -1);
        i = 0;
        iS = URL_SAFE_CHARS.length;
        while (i < iS) {
            Base64Util.URL_SAFE_INV[Base64Util.URL_SAFE_CHARS[i]] = i++;
        }
        Base64Util.URL_SAFE_INV[61] = 0;
    }
}

