/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.utils;

import com.xforceplus.apollo.utils.ErrorUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassLoaderUtil {
    private static final Logger logger = LoggerFactory.getLogger(ClassLoaderUtil.class);
    public static Map<String, JarURLConnection> cachedJarFiles = new HashedMap();
    private static Method addURL = ClassLoaderUtil.initAddMethod();
    private static URLClassLoader system = (URLClassLoader)ClassLoader.getSystemClassLoader();

    private static final Method initAddMethod() {
        try {
            Method add = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            add.setAccessible(true);
            return add;
        }
        catch (Exception e) {
            logger.error(ErrorUtil.getStackMsg(e));
            return null;
        }
    }

    private static final void loopFiles(File file, List<File> files) {
        if (file.isDirectory()) {
            File[] tmps;
            for (File tmp : tmps = file.listFiles()) {
                ClassLoaderUtil.loopFiles(tmp, files);
            }
        } else if (file.getAbsolutePath().endsWith(".jar") || file.getAbsolutePath().endsWith(".zip")) {
            files.add(file);
        }
    }

    public static final void loadJarFile(File file) {
        try {
            addURL.invoke((Object)system, file.toURI().toURL());
            URLConnection uc = file.toURI().toURL().openConnection();
            if (uc instanceof JarURLConnection) {
                uc.setUseCaches(true);
                ((JarURLConnection)uc).getManifest();
                cachedJarFiles.put(file.getName(), (JarURLConnection)uc);
            }
        }
        catch (Exception e) {
            logger.error(ErrorUtil.getStackMsg(e));
        }
    }

    public static final void loadJarPath(String path) {
        ArrayList<File> files = new ArrayList<File>();
        File lib = new File(path);
        ClassLoaderUtil.loopFiles(lib, files);
        for (File file : files) {
            ClassLoaderUtil.loadJarFile(file);
        }
    }

    public static final void unLoadJar(String jarName) {
        JarURLConnection jarURLConnection = cachedJarFiles.get(jarName);
        if (null != jarURLConnection) {
            try {
                jarURLConnection.getJarFile().close();
            }
            catch (IOException e) {
                logger.error(ErrorUtil.getStackMsg(e));
            }
            jarURLConnection = null;
        }
    }
}

