/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.utils;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateFormatUtil {
    public static final String DATE_YEAR_MONTH_FORMAT = "yyyy-MM";
    public static final String YEAR_MONTH_FORMAT = "yyyyMM";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String CTS_DATE_FORMAT = "EEE MMM dd HH:mm:ss zzz yyyy";
    public static final String DATE_TIME_FORMAT_14 = "yyyyMMddHHmmss";
    public static final String UTC_DATE_FORMAT = "EEE MMM dd HH:mm:ss ZZZ yyyy";
    public static final String DATE_YEAR_FORMAT = "yyyy";
    public static final String DATE_FORMAT_MM = "yyyy-MM-dd HH:mm";
    public static final String DATE_FORMAT_MM_SS = "mm:ss";

    public static String getAddHoursDate(Date date, int hours, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        long Time = date.getTime() / 1000L + (long)(3600 * hours);
        date.setTime(Time * 1000L);
        String strDate = sdf.format(date);
        return strDate;
    }

    public static String getDateAfterAddDay(String date, int days) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(sdf.parse(date));
        calendar.add(5, days);
        return sdf.format(calendar.getTime());
    }

    public static Date getDateAfterDay(String date, int days) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(sdf.parse(date));
        calendar.add(5, days);
        return calendar.getTime();
    }

    public static String getDateAfterAddMonth(String date, int month) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_YEAR_MONTH_FORMAT);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(sdf.parse(date));
        calendar.add(2, month);
        return sdf.format(calendar.getTime());
    }

    public static int compare_date(String date1, String date2) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_TIME_FORMAT);
        try {
            Date dt1 = sdf.parse(date1);
            Date dt2 = sdf.parse(date2);
            if (dt1.getTime() > dt2.getTime()) {
                return 1;
            }
            if (dt1.getTime() < dt2.getTime()) {
                return -1;
            }
            return 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    public static boolean compareDate(String beginDate, String endDate, String compareDate) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        try {
            Date be = sdf.parse(beginDate);
            Date en = sdf.parse(endDate);
            Date co = sdf.parse(compareDate);
            if (co.compareTo(be) >= 0 && co.compareTo(en) <= 0) {
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public static String getCurrentFormatDateTime() {
        Date currentDate = DateFormatUtil.getCurrentDate();
        SimpleDateFormat dateFormator = new SimpleDateFormat(DATE_TIME_FORMAT);
        return dateFormator.format(currentDate);
    }

    public static String getCurrentFormatYear() {
        Date currentDate = DateFormatUtil.getCurrentDate();
        SimpleDateFormat dateFormator = new SimpleDateFormat(DATE_YEAR_FORMAT);
        return dateFormator.format(currentDate);
    }

    public static String getCurrFormatDateTime() {
        Date currentDate = DateFormatUtil.getCurrentDate();
        SimpleDateFormat dateFormator = new SimpleDateFormat(DATE_FORMAT);
        return dateFormator.format(currentDate);
    }

    public static Date getCurrentDate() {
        return new Date(DateFormatUtil.getCurrentTimeMillis());
    }

    public static long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static String formatDate(Date date, String pattern) {
        if (DateFormatUtil.checkPara(pattern) || DateFormatUtil.checkPara(date)) {
            return "";
        }
        SimpleDateFormat dateFormator = new SimpleDateFormat(pattern);
        return dateFormator.format(date);
    }

    public static Date parseStrToDateTime(String dateStr) {
        if (DateFormatUtil.checkPara(dateStr)) {
            return null;
        }
        SimpleDateFormat dateFormator = new SimpleDateFormat(DATE_TIME_FORMAT);
        Date resDate = dateFormator.parse(dateStr, new ParsePosition(0));
        return resDate;
    }

    public static Date parseStringToDate(String dateStr) {
        if (DateFormatUtil.checkPara(dateStr)) {
            return null;
        }
        SimpleDateFormat dateFormator = new SimpleDateFormat(DATE_FORMAT);
        Date resDate = dateFormator.parse(dateStr, new ParsePosition(0));
        return resDate;
    }

    public static Date parseUTCStrToDate(String ctsStr) throws ParseException {
        if (DateFormatUtil.checkPara(ctsStr)) {
            return null;
        }
        ctsStr = ctsStr.replace("UTC", "");
        ctsStr = ctsStr.replace("GMT", "");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(UTC_DATE_FORMAT, Locale.US);
        Date date = null;
        try {
            date = simpleDateFormat.parse(ctsStr);
        }
        catch (ParseException e) {
            simpleDateFormat = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss ZZZ", Locale.US);
            date = simpleDateFormat.parse(ctsStr);
        }
        return date;
    }

    public static Date parseCTSStrToDate(String ctsStr) throws ParseException {
        if (DateFormatUtil.checkPara(ctsStr)) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(CTS_DATE_FORMAT, Locale.US);
        Date date = simpleDateFormat.parse(ctsStr);
        return date;
    }

    public static Date str2Date(String str, String format) throws ParseException {
        if (DateFormatUtil.checkPara(str)) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        Date date = simpleDateFormat.parse(str);
        return date;
    }

    public static Date str2Date(String str) throws ParseException {
        if (DateFormatUtil.checkPara(str)) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_TIME_FORMAT_14);
        Date date = simpleDateFormat.parse(str);
        return date;
    }

    private static boolean checkPara(Object para) {
        return null == para || "".equals(para);
    }

    public static String getTimeDifference(Date oldDate, Date newDate) {
        long between = (newDate.getTime() - oldDate.getTime()) / 1000L;
        long day1 = between / 86400L;
        long hour1 = between % 86400L / 3600L;
        long minute1 = between % 3600L / 60L;
        long second1 = between % 60L;
        return "" + day1 + "\u5929" + hour1 + "\u5c0f\u65f6" + minute1 + "\u5206" + second1 + "\u79d2";
    }

    public static String getDate(int type) {
        Calendar c = Calendar.getInstance();
        switch (type) {
            case 1: {
                c.set(7, 2);
                return DateFormatUtil.formatDate(c.getTime(), DATE_FORMAT);
            }
            case 2: {
                c.set(7, 2);
                c.add(4, -1);
                return DateFormatUtil.formatDate(c.getTime(), DATE_FORMAT);
            }
            case 3: {
                c.set(7, 2);
                c.add(4, -1);
                c.add(7, 6);
                return DateFormatUtil.formatDate(c.getTime(), DATE_FORMAT);
            }
            case 4: {
                c.set(5, 1);
                c.add(5, -1);
                c.set(5, 1);
                return DateFormatUtil.formatDate(c.getTime(), DATE_FORMAT);
            }
            case 5: {
                c.set(5, 1);
                c.add(5, -1);
                return DateFormatUtil.formatDate(c.getTime(), DATE_FORMAT);
            }
            case 6: {
                c.set(5, 1);
                return DateFormatUtil.formatDate(c.getTime(), DATE_FORMAT);
            }
        }
        return DateFormatUtil.formatDate(new Date(), DATE_FORMAT);
    }

    public static String getDateByDiff(int diff) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -diff);
        Date date = calendar.getTime();
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
        return df.format(date);
    }

    public static String getDateByDiff2(int diff) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -diff + 1);
        Date date = calendar.getTime();
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
        return df.format(date);
    }

    public static long getQuot(String startdate, String enddate) {
        long m_intervalday = 0L;
        SimpleDateFormat m_simpledateformat = new SimpleDateFormat(DATE_FORMAT);
        try {
            Date date1 = m_simpledateformat.parse(startdate);
            Date date2 = m_simpledateformat.parse(enddate);
            m_intervalday = date2.getTime() - date1.getTime();
            m_intervalday = m_intervalday / 1000L / 60L / 60L / 24L;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return m_intervalday;
    }

    public static int[] getDateDifferenceInMonthAndDay(Date olderDate, Date newerDate) throws IllegalArgumentException {
        int[] differenceInMonthAndDay = new int[2];
        int years = 0;
        int months = 0;
        int days = 0;
        Calendar older = Calendar.getInstance();
        Calendar newer = Calendar.getInstance();
        older.setTime(olderDate);
        newer.setTime(newerDate);
        if (olderDate.getTime() > newerDate.getTime()) {
            throw new IllegalArgumentException();
        }
        years = newer.get(1) - older.get(1);
        if (years >= 0) {
            months = newer.get(2) - older.get(2) + 12 * years;
            older.add(2, months);
            days = newer.get(5) - older.get(5);
            if (days < 0) {
                older.add(2, -1);
            }
            days = DateFormatUtil.daysBetween(newer.getTime(), older.getTime());
            differenceInMonthAndDay[0] = --months;
            differenceInMonthAndDay[1] = days;
        }
        return differenceInMonthAndDay;
    }

    public static int daysBetween(Date newerDate, Date olderDate) {
        Calendar cNow = Calendar.getInstance();
        Calendar cReturnDate = Calendar.getInstance();
        cNow.setTime(newerDate);
        cReturnDate.setTime(olderDate);
        DateFormatUtil.setTimeToMidnight(cNow);
        DateFormatUtil.setTimeToMidnight(cReturnDate);
        long todayMs = cNow.getTimeInMillis();
        long returnMs = cReturnDate.getTimeInMillis();
        long intervalMs = todayMs - returnMs;
        return DateFormatUtil.millisecondsToDays(intervalMs);
    }

    private static int millisecondsToDays(long intervalMs) {
        return (int)(intervalMs / 86400000L);
    }

    private static void setTimeToMidnight(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
    }

    public static boolean judgeYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static int daysBetween(String startDate, String endDate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        Calendar cal = Calendar.getInstance();
        cal.setTime(sdf.parse(startDate));
        long time1 = cal.getTimeInMillis();
        cal.setTime(sdf.parse(endDate));
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(between_days));
    }

    public static Date formatDate(Date date) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        return sdf.parse(sdf.format(date));
    }

    public static Date getCurMonthFirst() {
        Calendar c = Calendar.getInstance();
        c.add(2, 0);
        c.set(5, 1);
        return c.getTime();
    }

    public static Date getCurMonthEnd() {
        Calendar ca = Calendar.getInstance();
        ca.set(5, ca.getActualMaximum(5));
        return ca.getTime();
    }

    public static Calendar setCalendar(int year, int month, int date) {
        Calendar cl = Calendar.getInstance();
        cl.set(year, month - 1, date);
        return cl;
    }

    public static Date getDiffDay(Calendar cl, int i) {
        int day = cl.get(5);
        cl.set(5, day + i);
        return cl.getTime();
    }

    public static String formatDate(Timestamp timestamp, String pattern) {
        if (DateFormatUtil.checkPara(pattern) || DateFormatUtil.checkPara(timestamp)) {
            return "";
        }
        SimpleDateFormat dateFormator = new SimpleDateFormat(pattern);
        return dateFormator.format(timestamp.getTime());
    }

    public static long getHours(Date date1, Date date2) {
        long seconds = Math.abs(date2.getTime() - date1.getTime()) / 1000L;
        return seconds / 3600L;
    }

    public static String getDateStr(Date localDate) {
        long localTimeInMillis = localDate.getTime();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(localTimeInMillis);
        int zoneOffset = calendar.get(15);
        int dstOffset = calendar.get(16);
        calendar.add(14, -(zoneOffset + dstOffset));
        Date utcDate = new Date(calendar.getTimeInMillis());
        return DateFormatUtil.formatDate(utcDate, DATE_FORMAT);
    }

    public static String getDateByDiff(int diff, String format) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -diff);
        Date date = calendar.getTime();
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(date);
    }
}

