/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.utils;

import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorUtil {
    private static final Logger logger = LoggerFactory.getLogger(ErrorUtil.class);
    public static Class HOLD_CLAZZ;
    public static String USER_ID;
    private static Method method;
    private static Object newInstance;
    private static Set<Integer> vSets;
    private static final int vMax = 200;
    private static long desTime;
    private static long startTime;

    public static String getStackMsg(Exception e) {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] stackArray = e.getStackTrace();
        for (int i = 0; i < stackArray.length; ++i) {
            StackTraceElement element = stackArray[i];
            sb.append(element.toString() + "\n");
        }
        sb.append(e.getMessage());
        String m = sb.toString();
        return m;
    }

    public static String getStackMsg(Exception e, String elseMsg) {
        StringBuilder sb = new StringBuilder();
        sb.append(elseMsg);
        StackTraceElement[] stackArray = e.getStackTrace();
        for (int i = 0; i < stackArray.length; ++i) {
            StackTraceElement element = stackArray[i];
            sb.append(element.toString() + "\n");
        }
        sb.append(e.getMessage());
        String m = sb.toString();
        ErrorUtil.holdErrMsg(m);
        return m;
    }

    public static String getStackMsg(Throwable e) {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] stackArray = e.getStackTrace();
        for (int i = 0; i < stackArray.length; ++i) {
            StackTraceElement element = stackArray[i];
            sb.append(element.toString() + "\n");
        }
        sb.append(e.getMessage());
        String msg = sb.toString();
        return msg;
    }

    public static String getStackMsg(Throwable e, String elseMsg) {
        StringBuffer sb = new StringBuffer();
        sb.append(elseMsg);
        StackTraceElement[] stackArray = e.getStackTrace();
        for (int i = 0; i < stackArray.length; ++i) {
            StackTraceElement element = stackArray[i];
            sb.append(element.toString() + "\n");
        }
        sb.append(e.getMessage());
        String msg = sb.toString();
        return msg;
    }

    public static void errMsgUpload(String msg) {
        ErrorUtil.holdErrMsg(msg);
    }

    private static void holdErrMsg(String msg) {
        try {
            if (null != HOLD_CLAZZ) {
                if (null == method) {
                    method = HOLD_CLAZZ.getMethod("doHandler", String.class);
                }
                if (null == method) {
                    return;
                }
                if (null == newInstance) {
                    newInstance = HOLD_CLAZZ.newInstance();
                }
                method.invoke(newInstance, msg);
            }
        }
        catch (NoSuchMethodException e) {
            HOLD_CLAZZ = null;
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            HOLD_CLAZZ = null;
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            HOLD_CLAZZ = null;
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            HOLD_CLAZZ = null;
            e.printStackTrace();
        }
    }

    public static String holdExceptionMsg(Exception e) {
        return ErrorUtil.getStackMsg(e);
    }

    public static void LoggerError(String title, Throwable e) {
        logger.error("{}", (Object)title, (Object)e);
        if (0L == startTime) {
            startTime = System.currentTimeMillis();
        } else {
            long endTime = System.currentTimeMillis();
            if (endTime - startTime >= desTime) {
                vSets.clear();
            }
        }
        if (vSets.size() >= 200) {
            vSets.clear();
        }
        if (vSets.add(title.hashCode())) {
            ErrorUtil.uploadLog(title, e);
        }
    }

    private static void uploadLog(String title, Throwable e) {
        String errMsg = ErrorUtil.getStackMsg(e);
        ErrorUtil.holdErrMsg(String.format("%s %s %s", title, USER_ID, errMsg));
    }

    public static String holdExceptionMsg(Exception e, String elseMsg) {
        StringBuffer sb = new StringBuffer();
        sb.append(elseMsg);
        StackTraceElement[] stackArray = e.getStackTrace();
        for (int i = 0; i < stackArray.length; ++i) {
            StackTraceElement element = stackArray[i];
            sb.append(element.toString() + "\n");
        }
        sb.append(e.getMessage());
        String m = sb.toString();
        return m;
    }

    public static String holdExceptionMsg(Throwable e) {
        StringBuffer sb = new StringBuffer();
        StackTraceElement[] stackArray = e.getStackTrace();
        for (int i = 0; i < stackArray.length; ++i) {
            StackTraceElement element = stackArray[i];
            sb.append(element.toString() + "\n");
        }
        sb.append(e.getMessage());
        String msg = sb.toString();
        return msg;
    }

    static {
        vSets = Sets.newConcurrentHashSet();
        desTime = 30000L;
        startTime = 0L;
    }
}

