/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.utils;

import com.jcraft.jzlib.DeflaterOutputStream;
import com.jcraft.jzlib.InflaterInputStream;
import com.xforceplus.apollo.utils.ErrorUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBytesUtil {
    private static Logger logger = LoggerFactory.getLogger(FileBytesUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeFile(byte[] bfile, File file) {
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(bfile);
            String string = file.getPath();
            return string;
        }
        catch (Exception e) {
            logger.error(ErrorUtil.getStackMsg(e));
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e1) {
                    logger.error(ErrorUtil.getStackMsg(e1));
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e1) {
                    logger.error(ErrorUtil.getStackMsg(e1));
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createFile(byte[] bfile, String filePath, String fileName) {
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        try {
            File dir = new File(filePath);
            if (!dir.exists() || dir.isDirectory()) {
                dir.mkdirs();
            }
            File file = new File(filePath + File.separator + fileName);
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(bfile);
            String string = file.getPath();
            return string;
        }
        catch (Exception e) {
            logger.error(ErrorUtil.getStackMsg(e));
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e1) {
                    logger.error(ErrorUtil.getStackMsg(e1));
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e1) {
                    logger.error(ErrorUtil.getStackMsg(e1));
                }
            }
        }
        return null;
    }

    public static String bytesToHexString(byte[] bArray) {
        StringBuffer sb = new StringBuffer(bArray.length);
        for (int i = 0; i < bArray.length; ++i) {
            String sTemp = Integer.toHexString(0xFF & bArray[i]);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTemp.toUpperCase());
        }
        return sb.toString();
    }

    public static byte[] jzlib(byte[] object) {
        byte[] data = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DeflaterOutputStream zOut = new DeflaterOutputStream((OutputStream)out);
            DataOutputStream objOut = new DataOutputStream((OutputStream)zOut);
            objOut.write(object);
            objOut.flush();
            zOut.close();
            data = out.toByteArray();
            out.close();
        }
        catch (IOException e) {
            logger.error(ErrorUtil.getStackMsg(e));
        }
        return data;
    }

    public static byte[] unjzlib(byte[] object) {
        byte[] data = null;
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(object);
            InflaterInputStream zIn = new InflaterInputStream((InputStream)in);
            byte[] buf = new byte[1024];
            int num = -1;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((num = zIn.read(buf, 0, buf.length)) != -1) {
                baos.write(buf, 0, num);
            }
            data = baos.toByteArray();
            baos.flush();
            baos.close();
            zIn.close();
            in.close();
        }
        catch (IOException e) {
            logger.error(ErrorUtil.getStackMsg(e));
        }
        return data;
    }

    public static byte[] hexStringToByte(String hex) {
        int len = hex.length() / 2;
        byte[] result = new byte[len];
        char[] achar = hex.toCharArray();
        for (int i = 0; i < len; ++i) {
            int pos = i * 2;
            result[i] = (byte)(FileBytesUtil.toByte(achar[pos]) << 4 | FileBytesUtil.toByte(achar[pos + 1]));
        }
        return result;
    }

    private static int toByte(char c) {
        byte b = (byte)"0123456789ABCDEF".indexOf(c);
        return b;
    }
}

