/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static Logger logger = LoggerFactory.getLogger(FileUtil.class);

    public static File getFile(String filename) throws IOException {
        File f = new File(filename);
        File pf = f.getParentFile();
        if (!pf.exists()) {
            pf.mkdirs();
        }
        if (!f.exists()) {
            f.createNewFile();
        }
        return f;
    }

    public static boolean mkdirs(String filepath) {
        File file = new File(filepath);
        if (!file.exists()) {
            file.mkdirs();
        }
        return true;
    }

    public static File getFile(String path, String filename) throws IOException {
        return FileUtil.getFile(FileUtil.getRealFileName(path, filename));
    }

    public static String getRealFileName(String path, String filename) {
        char endChar = path.charAt(path.length() - 1);
        if ("/".equals(Character.valueOf(endChar)) || "\\".equals(Character.valueOf(endChar))) {
            return path + filename;
        }
        return path + "/" + filename;
    }

    public static String getFileContent(String filename) {
        File file = new File(filename);
        StringBuilder sb = new StringBuilder();
        try (FileInputStream fin = new FileInputStream(file);
             BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fin, "utf-8"));){
            String str = null;
            while ((str = reader.readLine()) != null) {
                sb.append(str);
            }
        }
        catch (Exception e) {
            logger.error(filename + " >> \u8bfb\u53d6\u6587\u4ef6\u5185\u5bb9\u5931\u8d25", (Throwable)e);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties getProperties(String filename) {
        logger.info("\u8bfb\u53d6[ Jar ]\u5185\u914d\u7f6e\u6587\u4ef6\uff1a" + filename);
        Properties pros = new Properties();
        try {
            try (InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);){
                pros.load(in);
                return pros;
            }
            catch (Exception e) {
                block28: {
                    logger.info("\u8bfb\u53d6[ \u672c\u5730 ]\u914d\u7f6e\u6587\u4ef6\uff1a" + filename);
                    File file = new File(filename);
                    try {
                        FileInputStream fin;
                        block29: {
                            fin = new FileInputStream(file);
                            Throwable throwable = null;
                            try {
                                pros.load(fin);
                                if (fin == null) break block28;
                                if (throwable == null) break block29;
                            }
                            catch (Throwable throwable2) {
                                try {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                catch (Throwable throwable3) {
                                    if (fin == null) throw throwable3;
                                    if (throwable == null) {
                                        fin.close();
                                        throw throwable3;
                                    }
                                    try {
                                        fin.close();
                                        throw throwable3;
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                        throw throwable3;
                                    }
                                }
                            }
                            try {
                                fin.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        }
                        fin.close();
                    }
                    catch (Exception e1) {
                        logger.error("\u627e\u4e0d\u5230\uff1a" + filename + "\u914d\u7f6e\u6587\u4ef6");
                    }
                }
            }
        }
        finally {
            return pros;
        }
    }

    public static URL getFileURL(String filename) {
        File file = new File(filename);
        URL url = null;
        try {
            url = file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            logger.error("URL\u5730\u5740\u683c\u5f0f\u9519\u8bef", (Throwable)e);
            url = null;
        }
        return url;
    }
}

