/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.utils;

import com.xforceplus.apollo.utils.ErrorUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtil {
    private static Logger logger = LoggerFactory.getLogger(IOUtil.class);

    public static void close(Closeable ... closeables) throws IOException {
        if (closeables != null) {
            for (Closeable closeable : closeables) {
                if (closeable == null) continue;
                closeable.close();
            }
        }
    }

    public static void closeQuietly(Closeable ... closeables) {
        try {
            IOUtil.close(closeables);
        }
        catch (IOException e) {
            logger.error(ErrorUtil.getStackMsg(e));
        }
    }

    public static byte[] changeFileToByte(FileInputStream fis) {
        byte[] buffer = null;
        try {
            int n;
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1000);
            byte[] b = new byte[1000];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            fis.close();
            bos.close();
            buffer = bos.toByteArray();
        }
        catch (FileNotFoundException e) {
            logger.error(ErrorUtil.getStackMsg(e));
        }
        catch (IOException e) {
            logger.error(ErrorUtil.getStackMsg(e));
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFile(byte[] bfile, String filePath, String fileName) {
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        File file = null;
        try {
            File dir = new File(filePath);
            if (!dir.exists() && dir.isDirectory()) {
                dir.mkdirs();
            }
            file = new File(filePath + File.separator + fileName);
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(bfile);
        }
        catch (Exception e) {
            logger.error(ErrorUtil.getStackMsg(e));
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e1) {
                    logger.error(ErrorUtil.getStackMsg(e1));
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e1) {
                    logger.error(ErrorUtil.getStackMsg(e1));
                }
            }
        }
    }

    public static String unblockReadStream(InputStream is, long timeout, TimeUnit unit) throws IOException, InterruptedException {
        return IOUtil.unblockReadStream(new BufferedReader(new InputStreamReader(is)), timeout, unit);
    }

    public static String unblockReadStream(BufferedReader reader, long timeout, TimeUnit unit) throws IOException, InterruptedException {
        long rem;
        StringBuilder data = new StringBuilder();
        AtomicBoolean isException = new AtomicBoolean(false);
        AtomicBoolean isBlock = new AtomicBoolean(false);
        AtomicBoolean isOver = new AtomicBoolean(false);
        AtomicLong streamBlockTime = new AtomicLong(0L);
        Thread t = new Thread(() -> {
            try {
                String line;
                while (IOUtil.setAndGet(isBlock, true) && (line = reader.readLine()) != null) {
                    isBlock.set(false);
                    streamBlockTime.set(0L);
                    data.append(line).append(System.lineSeparator());
                }
                isOver.set(true);
            }
            catch (IOException e) {
                isException.set(true);
            }
        });
        t.start();
        long l = rem = unit.toMillis(timeout) <= 1000L ? 2000L : unit.toMillis(timeout);
        while (!isOver.get()) {
            if (isException.get()) {
                throw new IOException("read byte fail");
            }
            if (isBlock.get()) {
                if (streamBlockTime.get() < rem) {
                    Thread.sleep(50L);
                    long l2 = streamBlockTime.addAndGet(50L);
                    continue;
                }
                t.interrupt();
                break;
            }
            Thread.sleep(100L);
        }
        return data.toString();
    }

    private static boolean setAndGet(AtomicBoolean atomicBoolean, boolean setValue) {
        atomicBoolean.set(setValue);
        return atomicBoolean.get();
    }
}

