/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.utils;

import com.xforceplus.apollo.utils.IOUtil;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class ImageUtil {
    public static byte[] compressImg(byte[] srcBytes, double scale, FileType fileType) throws IOException, InterruptedException {
        int deskWidth;
        int deskHeight;
        int srcWidth;
        Image src = ImageUtil.bytesToImage(srcBytes);
        int srcHeight = src.getHeight(null);
        double comBase = srcHeight > (srcWidth = src.getWidth(null)) ? (double)srcHeight * scale : (double)srcWidth * scale;
        double srcScale = (double)srcHeight / (double)srcWidth;
        if ((double)srcHeight > comBase || (double)srcWidth > comBase) {
            if (srcScale >= scale || 1.0 / srcScale > scale) {
                if (srcScale >= scale) {
                    deskHeight = (int)comBase;
                    deskWidth = srcWidth * deskHeight / srcHeight;
                } else {
                    deskWidth = (int)comBase;
                    deskHeight = srcHeight * deskWidth / srcWidth;
                }
            } else if ((double)srcHeight > comBase) {
                deskHeight = (int)comBase;
                deskWidth = srcWidth * deskHeight / srcHeight;
            } else {
                deskWidth = (int)comBase;
                deskHeight = srcHeight * deskWidth / srcWidth;
            }
        } else {
            deskHeight = srcHeight;
            deskWidth = srcWidth;
        }
        BufferedImage tag = new BufferedImage(deskWidth, deskHeight, 5);
        tag.getGraphics().drawImage(src, 0, 0, deskWidth, deskHeight, null);
        return ImageUtil.imageToBytes(tag, fileType.name());
    }

    public static Image bytesToImage(byte[] bytes) throws InterruptedException {
        Image image = Toolkit.getDefaultToolkit().createImage(bytes);
        MediaTracker mt = new MediaTracker(new Label());
        mt.addImage(image, 0);
        mt.waitForAll();
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] imageToBytes(BufferedImage bImage, String format) throws IOException {
        byte[] bytes;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)bImage, format, out);
            bytes = out.toByteArray();
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] cutImage(byte[] bytes, int destWidth, int destHeight, int x, int y, FileType fileType) throws IOException {
        BufferedImage bi;
        InputStream input = null;
        ImageInputStream iis = null;
        try {
            Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(fileType.name());
            ImageReader reader = iterator.next();
            input = new ByteArrayInputStream(bytes);
            iis = ImageIO.createImageInputStream(input);
            reader.setInput(iis, true);
            ImageReadParam param = reader.getDefaultReadParam();
            if (destHeight == 0 && destWidth == 0) {
                destHeight = reader.getHeight(0);
                destWidth = reader.getWidth(0);
            }
            Rectangle rectangle = new Rectangle(x, y, destWidth, destHeight);
            param.setSourceRegion(rectangle);
            bi = reader.read(0, param);
        }
        finally {
            if (null != input) {
                input.close();
            }
            if (null != iis) {
                iis.close();
            }
        }
        return ImageUtil.imageToBytes(bi, fileType.name());
    }

    public static void main(String[] args) throws Exception {
        byte[] bytes = ImageUtil.compressImg(IOUtil.changeFileToByte(new FileInputStream("C:\\Users\\Administrator\\Desktop\\logs\\20180713112744.png")), 0.5, FileType.PNG);
        System.out.println(bytes.length);
        File file = new File("C:\\Users\\Administrator\\Desktop\\logs\\20180713112744666889902.png");
        FileOutputStream output = new FileOutputStream(file);
        BufferedOutputStream bufferedOutput = new BufferedOutputStream(output);
        bufferedOutput.write(bytes);
    }

    static enum FileType {
        JPEG,
        PNG,
        BMP,
        GIF;

    }
}

