/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.databind.type.MapType;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonUtil {
    private ObjectMapper mapper = new ObjectMapper();
    private static volatile JacksonUtil jacksonUtil;
    private static final Logger logger;

    private JacksonUtil() {
        SimpleModule module = new SimpleModule();
        module.addSerializer(Double.class, (JsonSerializer)new CustomDoubleSerializer());
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)module);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        mapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
        mapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
    }

    private JacksonUtil(JsonInclude.Include include) {
        this.mapper.setSerializationInclusion(include);
    }

    public JacksonUtil(JsonInclude.Include include, SimpleDateFormat fmt) {
        this.mapper.setSerializationInclusion(include);
        this.mapper.setDateFormat((DateFormat)fmt);
    }

    public <T> T fromJson(String jsonString, Class<T> clazz) {
        if (StringUtils.isEmpty((CharSequence)jsonString)) {
            return null;
        }
        Object t = null;
        try {
            t = this.mapper.readValue(jsonString, clazz);
        }
        catch (IOException e) {
            logger.error("JSON\u8f6c\u5316\u4e3aObject\u5f02\u5e38\uff1a", (Throwable)e);
        }
        return (T)t;
    }

    public <K, V> Map<K, V> convertToMap(Object obj, Class<K> ck, Class<V> cv) {
        if (null == obj) {
            return null;
        }
        Map t = null;
        MapType mapType = this.mapper.getTypeFactory().constructMapType(HashMap.class, ck, cv);
        t = (Map)this.mapper.convertValue(obj, (JavaType)mapType);
        return t;
    }

    public <T> List<T> fromJsonToList(String str, Class<T> cl) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return null;
        }
        List t = null;
        JavaType javaType = this.mapper.getTypeFactory().constructParametricType(ArrayList.class, new Class[]{cl});
        try {
            t = (List)this.mapper.readValue(str, javaType);
        }
        catch (IOException e) {
            logger.error("JSON\u8f6c\u5316\u4e3a\u96c6\u5408\u5f02\u5e38\uff1a", (Throwable)e);
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toJson(Object object) {
        String json_str = "[]";
        try {
            json_str = this.mapper.writeValueAsString(object);
            return json_str;
        }
        catch (Exception e) {
            json_str = "[]";
            return json_str;
        }
        finally {
            return json_str;
        }
    }

    public String toJson(Object object, String filterName) throws Exception {
        String json_str = "[]";
        try {
            SimpleFilterProvider filterProvider = new SimpleFilterProvider().addFilter(filterName, SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[0]));
            json_str = this.mapper.writer((FilterProvider)filterProvider).writeValueAsString(object);
            return json_str;
        }
        catch (Exception e) {
            json_str = "[]";
            throw new Exception(e);
        }
        finally {
            return json_str;
        }
    }

    public String toJson(Object object, String[] args, String filterName) throws Exception {
        String json = "[]";
        try {
            if (this.mapper == null) {
            }
            SimpleFilterProvider filterProvider = new SimpleFilterProvider().addFilter(filterName, SimpleBeanPropertyFilter.serializeAllExcept((String[])args));
            json = this.mapper.writer((FilterProvider)filterProvider).writeValueAsString(object);
            return json;
        }
        catch (Exception e) {
            json = "[]";
            throw new Exception(e);
        }
        finally {
            return json;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JacksonUtil getInstance() {
        if (null != jacksonUtil) return jacksonUtil;
        Class<JacksonUtil> clazz = JacksonUtil.class;
        synchronized (JacksonUtil.class) {
            if (null != jacksonUtil) return jacksonUtil;
            jacksonUtil = new JacksonUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return jacksonUtil;
        }
    }

    @Deprecated
    public static JacksonUtil getInstance(JsonInclude.Include include) {
        return new JacksonUtil(include);
    }

    @Deprecated
    public static JacksonUtil getInstance(JsonInclude.Include include, SimpleDateFormat fmt) {
        if (fmt == null) {
            fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        return new JacksonUtil(include, fmt);
    }

    public boolean isJson(String content) {
        try {
            JsonNode rootNode = this.mapper.readTree(content);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void main(String[] args) {
        long a = System.currentTimeMillis();
        String json = "{\"name\":\"myName\",\"age\":\"11\",\"counts\":{\"d\":4,\"e\":5,\"b\":2,\"c\":3,\"a\":1}}";
        Map map = JacksonUtil.getInstance().fromJson(json, HashMap.class);
        System.out.println(StringEscapeUtils.unescapeJson((String)json));
    }

    static {
        logger = LoggerFactory.getLogger(JacksonUtil.class);
    }

    class CustomDoubleSerializer
    extends JsonSerializer<Double> {
        CustomDoubleSerializer() {
        }

        public void serialize(Double value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
            BigDecimal d = new BigDecimal(value.toString());
            gen.writeNumber(d.stripTrailingZeros().toPlainString());
        }

        public Class<Double> handledType() {
            return Double.class;
        }
    }
}

