/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.utils;

import com.xforceplus.apollo.utils.FileUtil;
import com.xforceplus.apollo.utils.ILoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.ClassLoaderUtil;

public class JarLoaderUtil
implements ILoader {
    private static Logger logger = LoggerFactory.getLogger(JarLoaderUtil.class);
    private static Map<String, URLClassLoader> loaders = new ConcurrentHashMap<String, URLClassLoader>();
    private static Map<String, Object> objs = new ConcurrentHashMap<String, Object>();
    private static JarLoaderUtil loader = null;

    private JarLoaderUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JarLoaderUtil getInstance() {
        if (loader != null) return loader;
        Class<JarLoaderUtil> clazz = JarLoaderUtil.class;
        synchronized (JarLoaderUtil.class) {
            if (loader != null) return loader;
            loader = new JarLoaderUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return loader;
        }
    }

    @Override
    public int download(URL url, String path, String saveFName) {
        URLConnection con = null;
        File file = null;
        boolean flag = true;
        try {
            con = url.openConnection();
            file = FileUtil.getFile(path, saveFName);
        }
        catch (IOException e) {
            flag = false;
            logger.error("\u4e0b\u8f7d[ " + url + "] \u5931\u8d25", (Throwable)e);
            return ILoader.FAIL_CONNECTION;
        }
        try (InputStream reader = con.getInputStream();
             FileOutputStream writer = new FileOutputStream(file);){
            int b = -1;
            byte[] buffer = new byte[1024];
            while ((b = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, b);
                Arrays.fill(buffer, 0, b, (byte)0);
            }
        }
        catch (IOException e) {
            logger.error("\u4fdd\u5b58 [" + file + "] \u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return ILoader.FAIL_SAVE_FILE;
        }
        return ILoader.SUCCESS;
    }

    @Override
    public int start(String key, URL[] jarUrls, String className, String methodName, Class[] argsType, Object[] args) {
        URLClassLoader loader = new URLClassLoader(jarUrls);
        Class<?> cl = null;
        try {
            cl = loader.loadClass(className);
            Method method = cl.getMethod(methodName, argsType);
            Object obj = cl.newInstance();
            objs.put(key, obj);
            loaders.put(key, loader);
            method.invoke(obj, args);
        }
        catch (ClassNotFoundException e) {
            objs.remove(key);
            loaders.remove(key);
            logger.error("\u627e\u4e0d\u5230\u542f\u52a8\u7c7b", (Throwable)e);
            return ILoader.FAIL_START;
        }
        catch (IllegalAccessException e) {
            objs.remove(key);
            loaders.remove(key);
            logger.error("\u65e0\u6cd5\u8bbf\u95ee\u542f\u52a8\u65b9\u6cd5", (Throwable)e);
            return ILoader.FAIL_START;
        }
        catch (InstantiationException e) {
            objs.remove(key);
            loaders.remove(key);
            logger.error("\u65e0\u6cd5\u5b9e\u4f8b\u5316\u542f\u52a8\u7c7b", (Throwable)e);
            return ILoader.FAIL_START;
        }
        catch (NoSuchMethodException e) {
            objs.remove(key);
            loaders.remove(key);
            logger.error("\u627e\u4e0d\u5230\u542f\u52a8\u65b9\u6cd5", (Throwable)e);
            return ILoader.FAIL_START;
        }
        catch (InvocationTargetException e) {
            objs.remove(key);
            loaders.remove(key);
            logger.error("\u8c03\u7528\u542f\u52a8\u65b9\u6cd5\u5f02\u5e38", (Throwable)e);
            return ILoader.FAIL_START;
        }
        return ILoader.SUCCESS;
    }

    @Override
    public int start(String key, URL[] jarUrls) {
        return this.start(key, jarUrls, "com.xforceplus.apollo.client.core.jdbc.SendActiveMQ", "main", new Class[0], new Object[0]);
    }

    @Override
    public int destroy(String key, String methodName, Class[] argsType, Object[] args) {
        Object obj = objs.get(key);
        if (obj == null) {
            return ILoader.FAIL_NOBJ_DESTROY;
        }
        Method method = null;
        try {
            method = obj.getClass().getMethod(methodName, argsType);
            method.invoke(obj, args);
            objs.remove(key);
            this.release(key);
        }
        catch (NoSuchMethodException e) {
            logger.error("\u627e\u4e0d\u5230\u9500\u6bc1\u65b9\u6cd5", (Throwable)e);
            return ILoader.FAIL_DNOT_METHOD;
        }
        catch (IllegalAccessException e) {
            logger.error("\u65e0\u6cd5\u8bbf\u95ee\u9500\u6bc1\u65b9\u6cd5", (Throwable)e);
            return ILoader.FAIL_DESTROY;
        }
        catch (InvocationTargetException e) {
            logger.error("\u8c03\u7528\u9500\u6bc1\u65b9\u6cd5\u5f02\u5e38", (Throwable)e);
            return ILoader.FAIL_DESTROY;
        }
        return ILoader.SUCCESS;
    }

    @Override
    public int destroy(String key) {
        return this.destroy(key, "destroy", new Class[0], new Object[0]);
    }

    private void release(String key) {
        ClassLoaderUtil.releaseLoader((URLClassLoader)loaders.get(key));
        loaders.remove(key);
    }

    public Object getObjectByKey(String key) {
        Object result = null;
        if (StringUtils.isNotBlank((CharSequence)key)) {
            result = objs.get(key);
        }
        return result;
    }
}

