/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.utils;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.CollectionSerializer;
import com.esotericsoftware.kryo.serializers.JavaSerializer;
import com.esotericsoftware.kryo.serializers.MapSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;

public class KyroUtil {
    public static <T extends Serializable> String serializationObject(T obj) {
        Kryo kryo = new Kryo();
        kryo.setReferences(false);
        kryo.register(obj.getClass(), (Serializer)new JavaSerializer());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Output output = new Output((OutputStream)baos);
        kryo.writeClassAndObject(output, obj);
        output.flush();
        output.close();
        byte[] b = baos.toByteArray();
        try {
            baos.flush();
            baos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Base64.encodeBase64String((byte[])b);
    }

    public static <T extends Serializable> T deserializationObject(String obj, Class<T> clazz) {
        Kryo kryo = new Kryo();
        kryo.setReferences(false);
        kryo.register(clazz, (Serializer)new JavaSerializer());
        ByteArrayInputStream bais = new ByteArrayInputStream(Base64.decodeBase64((String)obj));
        Input input = new Input((InputStream)bais);
        return (T)((Serializable)kryo.readClassAndObject(input));
    }

    public static <T extends Serializable> String serializationList(List<T> obj, Class<T> clazz) {
        Kryo kryo = new Kryo();
        kryo.setReferences(false);
        kryo.setRegistrationRequired(true);
        CollectionSerializer serializer = new CollectionSerializer();
        serializer.setElementClass(clazz, (Serializer)new JavaSerializer());
        serializer.setElementsCanBeNull(false);
        kryo.register(clazz, (Serializer)new JavaSerializer());
        kryo.register(ArrayList.class, (Serializer)serializer);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Output output = new Output((OutputStream)baos);
        kryo.writeObject(output, obj);
        output.flush();
        output.close();
        byte[] b = baos.toByteArray();
        try {
            baos.flush();
            baos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Base64.encodeBase64String((byte[])b);
    }

    public static <T extends Serializable> List<T> deserializationList(String obj, Class<T> clazz) {
        Kryo kryo = new Kryo();
        kryo.setReferences(false);
        kryo.setRegistrationRequired(true);
        CollectionSerializer serializer = new CollectionSerializer();
        serializer.setElementClass(clazz, (Serializer)new JavaSerializer());
        serializer.setElementsCanBeNull(false);
        kryo.register(clazz, (Serializer)new JavaSerializer());
        kryo.register(ArrayList.class, (Serializer)serializer);
        ByteArrayInputStream bais = new ByteArrayInputStream(Base64.decodeBase64((String)obj));
        Input input = new Input((InputStream)bais);
        return (List)kryo.readObject(input, ArrayList.class, (Serializer)serializer);
    }

    public static <T extends Serializable> String serializationMap(Map<String, T> obj, Class<T> clazz) {
        Kryo kryo = new Kryo();
        kryo.setReferences(false);
        kryo.setRegistrationRequired(true);
        MapSerializer serializer = new MapSerializer();
        serializer.setKeyClass(String.class, (Serializer)new JavaSerializer());
        serializer.setKeysCanBeNull(false);
        serializer.setValueClass(clazz, (Serializer)new JavaSerializer());
        serializer.setValuesCanBeNull(true);
        kryo.register(clazz, (Serializer)new JavaSerializer());
        kryo.register(HashMap.class, (Serializer)serializer);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Output output = new Output((OutputStream)baos);
        kryo.writeObject(output, obj);
        output.flush();
        output.close();
        byte[] b = baos.toByteArray();
        try {
            baos.flush();
            baos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Base64.encodeBase64String((byte[])b);
    }

    public static <T extends Serializable> Map<String, T> deserializationMap(String obj, Class<T> clazz) {
        Kryo kryo = new Kryo();
        kryo.setReferences(false);
        kryo.setRegistrationRequired(true);
        MapSerializer serializer = new MapSerializer();
        serializer.setKeyClass(String.class, (Serializer)new JavaSerializer());
        serializer.setKeysCanBeNull(false);
        serializer.setValueClass(clazz, (Serializer)new JavaSerializer());
        serializer.setValuesCanBeNull(true);
        kryo.register(clazz, (Serializer)new JavaSerializer());
        kryo.register(HashMap.class, (Serializer)serializer);
        ByteArrayInputStream bais = new ByteArrayInputStream(Base64.decodeBase64((String)obj));
        Input input = new Input((InputStream)bais);
        return (Map)kryo.readObject(input, HashMap.class, (Serializer)serializer);
    }

    public static <T extends Serializable> String serializationSet(Set<T> obj, Class<T> clazz) {
        Kryo kryo = new Kryo();
        kryo.setReferences(false);
        kryo.setRegistrationRequired(true);
        CollectionSerializer serializer = new CollectionSerializer();
        serializer.setElementClass(clazz, (Serializer)new JavaSerializer());
        serializer.setElementsCanBeNull(false);
        kryo.register(clazz, (Serializer)new JavaSerializer());
        kryo.register(HashSet.class, (Serializer)serializer);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Output output = new Output((OutputStream)baos);
        kryo.writeObject(output, obj);
        output.flush();
        output.close();
        byte[] b = baos.toByteArray();
        try {
            baos.flush();
            baos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Base64.encodeBase64String((byte[])b);
    }

    public static <T extends Serializable> Set<T> deserializationSet(String obj, Class<T> clazz) {
        Kryo kryo = new Kryo();
        kryo.setReferences(false);
        kryo.setRegistrationRequired(true);
        CollectionSerializer serializer = new CollectionSerializer();
        serializer.setElementClass(clazz, (Serializer)new JavaSerializer());
        serializer.setElementsCanBeNull(false);
        kryo.register(clazz, (Serializer)new JavaSerializer());
        kryo.register(HashSet.class, (Serializer)serializer);
        ByteArrayInputStream bais = new ByteArrayInputStream(Base64.decodeBase64((String)obj));
        Input input = new Input((InputStream)bais);
        return (Set)kryo.readObject(input, HashSet.class, (Serializer)serializer);
    }
}

