/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.nio.ch.FileChannelImpl;

public class MD5Util {
    private static Logger logger = LoggerFactory.getLogger(MD5Util.class);

    public static String getHexMD5Str(String arrIn, int bit) {
        String code = "";
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] arrB = md.digest(arrIn.getBytes());
            StringBuffer sb = new StringBuffer(32);
            for (int i = 0; i < arrB.length; ++i) {
                int intTmp;
                for (intTmp = arrB[i]; intTmp < 0; intTmp += 256) {
                }
                if (intTmp < 16) {
                    sb.append('0');
                }
                sb.append(Integer.toString(intTmp, 16));
            }
            code = bit == 16 ? sb.toString().substring(8, 24) : sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return code;
    }

    public static String getCacheKey(String targetName, String methodName, Object[] arguments) {
        StringBuffer sb = new StringBuffer();
        sb.append(targetName).append("").append(methodName);
        if (arguments != null && arguments.length != 0) {
            for (int i = 0; i < arguments.length; ++i) {
                sb.append(arguments[i]);
            }
        }
        String temp = sb.toString();
        temp = temp.replaceAll("\\W", "");
        return temp.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMD5ByFile(File file) {
        String value = null;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            value = MD5Util.getMD5ByFileInputStream(in);
        }
        catch (Exception e) {
            logger.error("\u6587\u4ef6MD5\u8f6c\u6362\u5f02\u5e38\uff1a", (Throwable)e);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error("\u6587\u4ef6\u8f93\u5165\u6d41\u5173\u95ed\u5f02\u5e38\uff1a", (Throwable)e);
                }
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMD5ByFileInputStream(FileInputStream in) {
        String value = null;
        FileChannel ch = null;
        try {
            ch = in.getChannel();
            MappedByteBuffer byteBuffer = ch.map(FileChannel.MapMode.READ_ONLY, 0L, in.available());
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(byteBuffer);
            BigInteger bi = new BigInteger(1, md5.digest());
            value = bi.toString(16);
            Method m = FileChannelImpl.class.getDeclaredMethod("unmap", MappedByteBuffer.class);
            m.setAccessible(true);
            m.invoke(FileChannelImpl.class, byteBuffer);
        }
        catch (FileNotFoundException e1) {
            logger.error("\u627e\u4e0d\u5230\u8f93\u5165\u6d41\u6587\u4ef6\uff1a", (Throwable)e1);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error(e.getMessage());
        }
        catch (IOException e) {
            logger.error("\u8f93\u5165\u6587\u4ef6\u6d41\u5f02\u5e38\uff1a", (Object)e.getMessage());
        }
        catch (NoSuchMethodException e) {
            logger.error("\u53cd\u5c04\uff1a\u627e\u4e0d\u5230\u65b9\u6cd5\uff1a", (Object)e.getMessage());
        }
        catch (IllegalAccessException e) {
            logger.error("\u53cd\u5c04\uff1a\u8bbf\u95ee\u6743\u9650\u5f02\u5e38\uff1a", (Object)e.getMessage());
        }
        catch (InvocationTargetException e) {
            logger.error("\u53cd\u5c04\uff1a\u8c03\u7528\u5f02\u5e38\uff1a", (Object)e.getMessage());
        }
        finally {
            if (ch != null) {
                try {
                    ch.close();
                    ch = null;
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u901a\u9053\u5f02\u5e38\uff1a", (Throwable)e);
                }
            }
        }
        return value;
    }

    public static void main(String[] args) {
        try {
            System.out.println(MD5Util.getHexMD5Str("1234", 16));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

