/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.utils;

import java.math.BigDecimal;
import java.text.DecimalFormat;

public class NumberUtil {
    public static String keepPrecision(String number, int precision) {
        BigDecimal bg = new BigDecimal(number);
        return bg.setScale(precision, 4).toPlainString();
    }

    public static String keepPrecision(Number number, int precision) {
        return NumberUtil.keepPrecision(String.valueOf(number), precision);
    }

    public static double keepPrecision(double number, int precision) {
        BigDecimal bg = new BigDecimal(number);
        return bg.setScale(precision, 4).doubleValue();
    }

    public static float keepPrecision(float number, int precision) {
        BigDecimal bg = new BigDecimal(number);
        return bg.setScale(precision, 4).floatValue();
    }

    public static double keepPrecisionDown(double number, int precision) {
        BigDecimal bg = new BigDecimal(number);
        return bg.setScale(precision, 1).doubleValue();
    }

    public static String formatMoney(Double money, int precision) {
        if (null == money || money <= 0.0) {
            return "0.00";
        }
        DecimalFormat format = new DecimalFormat();
        StringBuffer stringBuffer = new StringBuffer("##,###");
        if (precision > 0) {
            stringBuffer.append(".");
            for (int i = 0; i < precision; ++i) {
                stringBuffer.append("0");
            }
        }
        format.applyPattern(stringBuffer.toString());
        return format.format(money);
    }
}

