/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.utils;

public class OsInfoUtil {
    private static String OS = System.getProperty("os.name").toLowerCase();
    private static OsInfoUtil _instance = new OsInfoUtil();
    private EPlatform platform;

    private OsInfoUtil() {
    }

    public static boolean isLinux() {
        return OS.indexOf("linux") >= 0;
    }

    public static boolean isMacOS() {
        return OS.indexOf("mac") >= 0 && OS.indexOf("os") > 0 && OS.indexOf("x") < 0;
    }

    public static boolean isMacOSX() {
        return OS.indexOf("mac") >= 0 && OS.indexOf("os") > 0 && OS.indexOf("x") > 0;
    }

    public static boolean isWindows() {
        return OS.indexOf("windows") >= 0;
    }

    public static boolean isOS2() {
        return OS.indexOf("os/2") >= 0;
    }

    public static boolean isSolaris() {
        return OS.indexOf("solaris") >= 0;
    }

    public static boolean isSunOS() {
        return OS.indexOf("sunos") >= 0;
    }

    public static boolean isMPEiX() {
        return OS.indexOf("mpe/ix") >= 0;
    }

    public static boolean isHPUX() {
        return OS.indexOf("hp-ux") >= 0;
    }

    public static boolean isAix() {
        return OS.indexOf("aix") >= 0;
    }

    public static boolean isOS390() {
        return OS.indexOf("os/390") >= 0;
    }

    public static boolean isFreeBSD() {
        return OS.indexOf("freebsd") >= 0;
    }

    public static boolean isIrix() {
        return OS.indexOf("irix") >= 0;
    }

    public static boolean isDigitalUnix() {
        return OS.indexOf("digital") >= 0 && OS.indexOf("unix") > 0;
    }

    public static boolean isNetWare() {
        return OS.indexOf("netware") >= 0;
    }

    public static boolean isOSF1() {
        return OS.indexOf("osf1") >= 0;
    }

    public static boolean isOpenVMS() {
        return OS.indexOf("openvms") >= 0;
    }

    public static String getOSname() {
        OsInfoUtil._instance.platform = OsInfoUtil.isAix() ? EPlatform.AIX : (OsInfoUtil.isDigitalUnix() ? EPlatform.Digital_Unix : (OsInfoUtil.isFreeBSD() ? EPlatform.FreeBSD : (OsInfoUtil.isHPUX() ? EPlatform.HP_UX : (OsInfoUtil.isIrix() ? EPlatform.Irix : (OsInfoUtil.isLinux() ? EPlatform.Linux : (OsInfoUtil.isMacOS() ? EPlatform.Mac_OS : (OsInfoUtil.isMacOSX() ? EPlatform.Mac_OS_X : (OsInfoUtil.isMPEiX() ? EPlatform.MPEiX : (OsInfoUtil.isNetWare() ? EPlatform.NetWare_411 : (OsInfoUtil.isOpenVMS() ? EPlatform.OpenVMS : (OsInfoUtil.isOS2() ? EPlatform.OS2 : (OsInfoUtil.isOS390() ? EPlatform.OS390 : (OsInfoUtil.isOSF1() ? EPlatform.OSF1 : (OsInfoUtil.isSolaris() ? EPlatform.Solaris : (OsInfoUtil.isSunOS() ? EPlatform.SunOS : (OsInfoUtil.isWindows() ? EPlatform.Windows : EPlatform.Others))))))))))))))));
        return OsInfoUtil._instance.platform.description;
    }

    static enum EPlatform {
        Any("any"),
        Linux("Linux"),
        Mac_OS("Mac OS"),
        Mac_OS_X("Mac OS X"),
        Windows("Windows"),
        OS2("OS/2"),
        Solaris("Solaris"),
        SunOS("SunOS"),
        MPEiX("MPE/iX"),
        HP_UX("HP-UX"),
        AIX("AIX"),
        OS390("OS/390"),
        FreeBSD("FreeBSD"),
        Irix("Irix"),
        Digital_Unix("Digital Unix"),
        NetWare_411("NetWare"),
        OSF1("OSF1"),
        OpenVMS("OpenVMS"),
        Others("Others");

        private String description;

        private EPlatform(String desc) {
            this.description = desc;
        }

        public String toString() {
            return this.description;
        }
    }
}

