/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.utils;

import com.xforceplus.apollo.utils.IOUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;

public class ProcessUtil {
    private static final String DEFAULT_CHARSET_NAME = "UTF-8";

    public static Result run(String commend) {
        return ProcessUtil.run(commend, DEFAULT_CHARSET_NAME);
    }

    public static Result run(String commend, String charsetName) {
        StringTokenizer st = new StringTokenizer(commend);
        String[] commendArray = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            commendArray[i] = st.nextToken();
            ++i;
        }
        return ProcessUtil.run(Arrays.asList(commendArray), charsetName);
    }

    public static Result run(List<String> commend) {
        return ProcessUtil.run(commend, DEFAULT_CHARSET_NAME);
    }

    public static Result run(List<String> commend, String charsetName) {
        Result result = new Result();
        InputStream is = null;
        try {
            Process process = new ProcessBuilder(commend).redirectErrorStream(true).start();
            is = process.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, charsetName));
            String data = IOUtil.unblockReadStream(reader, 2000L, TimeUnit.MILLISECONDS);
            boolean b = process.waitFor(1000L, TimeUnit.MILLISECONDS);
            if (b) {
                result.code = process.exitValue();
            } else {
                result.code = -1;
                process.destroyForcibly();
            }
            result.data = data.trim();
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                ProcessUtil.closeStreamQuietly(is);
                throw throwable;
            }
        }
        ProcessUtil.closeStreamQuietly(is);
        return result;
    }

    private static void closeStreamQuietly(Closeable stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
    }

    public static class Result {
        public int code;
        public String data;
    }
}

