/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.utils;

import com.xforceplus.apollo.msg.SealedMessage;
import com.xforceplus.apollo.utils.JacksonUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class RequestNameUtil {
    public static List<String> getRealRequestNameList(String jsonRequestNames) {
        ArrayList<String> requestNameList = null;
        if (!StringUtils.isBlank((CharSequence)jsonRequestNames)) {
            requestNameList = new ArrayList<String>();
            List tmpRequestNameList = JacksonUtil.getInstance().fromJson(jsonRequestNames, List.class);
            for (String requestName : tmpRequestNameList) {
                requestName = requestName.substring(0, requestName.length() - "Out".length());
                requestNameList.add(requestName);
            }
        }
        return requestNameList;
    }

    public static Set<String> parseDestinationRule(SealedMessage.Header header, Set<String> oldDestinationUriList, List<Map<String, String>> ruleList) {
        HashSet<Object> destinationList = null;
        HashSet<String> destinationSet = null;
        if (CollectionUtils.isNotEmpty(ruleList)) {
            destinationSet = new HashSet<String>();
            for (Map<String, String> map : ruleList) {
                boolean flag = true;
                block11: for (Map.Entry<String, String> entry : map.entrySet()) {
                    switch (entry.getKey()) {
                        case "des_Inverse": {
                            continue block11;
                        }
                        case "des_ServiceCode": {
                            continue block11;
                        }
                        case "des_UserID": {
                            continue block11;
                        }
                    }
                    if (!StringUtils.isNotBlank((CharSequence)entry.getValue())) continue;
                    if (entry.getValue().equals(header.getOthers().get(entry.getKey()))) continue;
                    flag = false;
                }
                if (!flag) continue;
                String destination = map.get("des_UserID") + "##" + map.get("des_ServiceCode");
                if ("1".equals(map.get("des_Inverse"))) {
                    destinationSet.add(destination);
                    continue;
                }
                oldDestinationUriList.remove(destination);
            }
        }
        if (null != destinationSet && !destinationSet.isEmpty()) {
            destinationList = new HashSet(destinationSet);
        } else if (header.getOthers().containsKey("broadcastany")) {
            destinationList = new HashSet<String>(oldDestinationUriList);
        }
        return destinationList;
    }
}

