/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.utils;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class StringUtil {
    private static Pattern emailPattern = null;
    private static Pattern mobilePattern = null;

    private static boolean isEmpty(String value) {
        int strLen;
        if (value == null || (strLen = value.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(Object obj) {
        if (obj == null) {
            return false;
        }
        char[] chars = obj.toString().toCharArray();
        int length = chars.length;
        if (length < 1) {
            return false;
        }
        int i = 0;
        if (length > 1 && chars[0] == '-') {
            i = 1;
        }
        while (i < length) {
            if (!Character.isDigit(chars[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean areNotEmpty(String ... values) {
        boolean result = true;
        if (values == null || values.length == 0) {
            result = false;
        } else {
            for (String value : values) {
                result &= !StringUtil.isEmpty(value);
            }
        }
        return result;
    }

    public static boolean areEqual(String value1, String value2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        if (value1 != null) {
            return value1.equals(value2);
        }
        if (value2 != null) {
            return value2.equals(value1);
        }
        return true;
    }

    public static String parseCurrency(String Currency) {
        String realStr = "";
        realStr = Character.isDigit(Currency.charAt(0)) ? Currency : Currency.substring(1);
        String[] subStr = realStr.split(",");
        String finalStr = "";
        for (String str : subStr) {
            finalStr = finalStr + str;
        }
        return finalStr;
    }

    public static String nullDefaultValue(String value, String defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static String nullDefaultValue(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    public static Boolean isEmail(String value) {
        if (StringUtil.isEmpty(value)) {
            return false;
        }
        Matcher matcher = emailPattern.matcher(value);
        return matcher.find();
    }

    public static Boolean isMobile(String value) {
        if (StringUtil.isEmpty(value)) {
            return false;
        }
        Matcher matcher = mobilePattern.matcher(value);
        return matcher.find();
    }

    public static String join(List<String> list, String split) {
        if (split == null) {
            split = "";
        }
        StringBuilder values = new StringBuilder();
        if (list != null && !list.isEmpty()) {
            String nickFormater = "%s";
            for (String item : list) {
                if (StringUtil.isEmpty(item)) continue;
                values.append(String.format(nickFormater, item.trim()));
                nickFormater = split + "%s";
            }
        }
        return values.toString();
    }

    static {
        String regEx = "^(\\w)+(\\.\\w+)*@(\\w)+((\\.\\w+)+)$";
        emailPattern = Pattern.compile(regEx);
        regEx = "^1\\d{10}$";
        mobilePattern = Pattern.compile(regEx);
    }
}

