/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.utils;

import com.sun.management.OperatingSystemMXBean;
import com.xforceplus.apollo.utils.ErrorUtil;
import java.io.File;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;

public class SystemUtil {
    private static final Logger log = LoggerFactory.getLogger(SystemUtil.class);
    private static volatile SystemStatus systemStatus = null;
    private static volatile boolean canSystemInfoAccessed = true;

    public static synchronized SystemStatus getSystemInfo() {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        FutureTask<SystemStatus> future = new FutureTask<SystemStatus>(() -> {
            block4: {
                systemStatus = new SystemStatus();
                try {
                    File[] files;
                    SystemInfo systemInfo = new SystemInfo();
                    OperatingSystemMXBean osmxb = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
                    MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
                    MemoryUsage memoryUsage = memoryMXBean.getHeapMemoryUsage();
                    long initTotalMemorySize = memoryUsage.getInit();
                    long maxMemorySize = memoryUsage.getMax();
                    long usedMemorySize = memoryUsage.getUsed();
                    String osName = System.getProperty("os.name");
                    String totalMemorySize = new DecimalFormat("#.##").format((double)osmxb.getTotalPhysicalMemorySize() / 1024.0 / 1024.0 / 1024.0) + "G";
                    String freePhysicalMemorySize = new DecimalFormat("#.##").format((double)osmxb.getFreePhysicalMemorySize() / 1024.0 / 1024.0 / 1024.0) + "G";
                    String usedMemory = new DecimalFormat("#.##").format((double)(osmxb.getTotalPhysicalMemorySize() - osmxb.getFreePhysicalMemorySize()) / 1024.0 / 1024.0 / 1024.0) + "G";
                    ThreadGroup parentThread = Thread.currentThread().getThreadGroup();
                    while (parentThread.getParent() != null) {
                        parentThread = parentThread.getParent();
                    }
                    int totalThread = parentThread.activeCount();
                    for (File file : files = File.listRoots()) {
                        String total = new DecimalFormat("#.#").format((double)file.getTotalSpace() * 1.0 / 1024.0 / 1024.0 / 1024.0) + "G";
                        String free = new DecimalFormat("#.#").format((double)file.getFreeSpace() * 1.0 / 1024.0 / 1024.0 / 1024.0) + "G";
                        String un = new DecimalFormat("#.#").format((double)file.getUsableSpace() * 1.0 / 1024.0 / 1024.0 / 1024.0) + "G";
                        String path = file.getPath();
                        systemStatus.setDiskAva("\u53ef\u7528\u7a7a\u95f4:" + un);
                        systemStatus.setDiskMax(path + "\u603b:" + total);
                        systemStatus.setDiskUsed("\u7a7a\u95f2\u7a7a\u95f4:" + free);
                    }
                    systemStatus.setOs("\u64cd\u4f5c\u7cfb\u7edf:" + osName);
                    systemStatus.setStartTime("\u7a0b\u5e8f\u542f\u52a8\u65f6\u95f4:" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(ManagementFactory.getRuntimeMXBean().getStartTime())));
                    systemStatus.setCpuCore("cpu\u6838\u6570:" + Runtime.getRuntime().availableProcessors());
                    CentralProcessor processor = systemInfo.getHardware().getProcessor();
                    long[] prevTicks = processor.getSystemCpuLoadTicks();
                    TimeUnit.SECONDS.sleep(1L);
                    long[] ticks = processor.getSystemCpuLoadTicks();
                    long nice = ticks[CentralProcessor.TickType.NICE.getIndex()] - prevTicks[CentralProcessor.TickType.NICE.getIndex()];
                    long irq = ticks[CentralProcessor.TickType.IRQ.getIndex()] - prevTicks[CentralProcessor.TickType.IRQ.getIndex()];
                    long softirq = ticks[CentralProcessor.TickType.SOFTIRQ.getIndex()] - prevTicks[CentralProcessor.TickType.SOFTIRQ.getIndex()];
                    long steal = ticks[CentralProcessor.TickType.STEAL.getIndex()] - prevTicks[CentralProcessor.TickType.STEAL.getIndex()];
                    long cSys = ticks[CentralProcessor.TickType.SYSTEM.getIndex()] - prevTicks[CentralProcessor.TickType.SYSTEM.getIndex()];
                    long user = ticks[CentralProcessor.TickType.USER.getIndex()] - prevTicks[CentralProcessor.TickType.USER.getIndex()];
                    long iowait = ticks[CentralProcessor.TickType.IOWAIT.getIndex()] - prevTicks[CentralProcessor.TickType.IOWAIT.getIndex()];
                    long idle = ticks[CentralProcessor.TickType.IDLE.getIndex()] - prevTicks[CentralProcessor.TickType.IDLE.getIndex()];
                    long totalCpu = user + nice + cSys + idle + iowait + irq + softirq + steal;
                    systemStatus.setCpuSysUseRate("cpu\u7cfb\u7edf\u4f7f\u7528\u7387:" + new DecimalFormat("#.##%").format((double)cSys * 1.0 / (double)totalCpu));
                    systemStatus.setCpuUserUseRate("cpu\u7528\u6237\u4f7f\u7528\u7387:" + new DecimalFormat("#.##%").format((double)user * 1.0 / (double)totalCpu));
                    systemStatus.setJavaVersion("JAVA_VERSION:" + System.getProperty("java.version"));
                    systemStatus.setMemJavaMax("\u6700\u5927\u53ef\u7528\u5185\u5b58(JVM):" + new DecimalFormat("#.#").format((double)maxMemorySize * 1.0 / 1024.0 / 1024.0) + "M");
                    systemStatus.setMemJavaAva("\u521d\u59cb\u7684\u603b\u5185\u5b58(JVM):" + new DecimalFormat("#.#").format((double)initTotalMemorySize * 1.0 / 1024.0 / 1024.0) + "M");
                    systemStatus.setMemJavaUsed("\u5df2\u4f7f\u7528\u7684\u5185\u5b58(JVM):" + new DecimalFormat("#.#").format((double)usedMemorySize * 1.0 / 1024.0 / 1024.0) + "M");
                    systemStatus.setMemMax(totalMemorySize);
                    systemStatus.setMemAva(freePhysicalMemorySize);
                    systemStatus.setMemUsed(usedMemory);
                    systemStatus.setActiveThreads("\u603b\u7ebf\u7a0b\u6570:" + totalThread);
                }
                catch (Exception e) {
                    if (!canSystemInfoAccessed) break block4;
                    canSystemInfoAccessed = false;
                    log.warn(ErrorUtil.getStackMsg(e));
                }
            }
            return systemStatus;
        });
        exec.execute(future);
        try {
            systemStatus = future.get(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            future.cancel(true);
            log.error(ErrorUtil.getStackMsg(e));
        }
        catch (ExecutionException e) {
            future.cancel(true);
            log.error(ErrorUtil.getStackMsg(e));
        }
        catch (TimeoutException e) {
            future.cancel(true);
            log.error(ErrorUtil.getStackMsg(e));
        }
        finally {
            exec.shutdown();
        }
        return systemStatus;
    }

    public static String getOSName() {
        return System.getProperty("os.name").toLowerCase();
    }

    public static String getIPAddress() {
        StringBuffer ipAddress = new StringBuffer();
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface ni = netInterfaces.nextElement();
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress ip = addresses.nextElement();
                    if (ip.isLoopbackAddress() || ip.getHostAddress().indexOf(58) != -1) continue;
                    ipAddress.append(ni.getName() + ":" + ip.getHostAddress() + "||");
                }
            }
        }
        catch (Exception e) {
            log.error(ErrorUtil.getStackMsg(e));
        }
        return ipAddress.toString();
    }

    @Deprecated
    public static String getIP(String netInterfaceName) {
        StringBuffer ipAddress = new StringBuffer();
        Enumeration<NetworkInterface> allNetInterfaces = null;
        try {
            allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress ip = null;
            while (allNetInterfaces.hasMoreElements()) {
                Enumeration<InetAddress> addresses;
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                System.out.println(netInterface.getName());
                if (StringUtils.isNotBlank((CharSequence)netInterfaceName)) {
                    if (!netInterfaceName.equalsIgnoreCase(netInterface.getName())) continue;
                    addresses = netInterface.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        ip = addresses.nextElement();
                        if (ip == null || !(ip instanceof Inet4Address)) continue;
                        ipAddress.append(ip.getHostAddress() + ";");
                    }
                    break;
                }
                addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    ip = addresses.nextElement();
                    if (ip == null || !(ip instanceof Inet4Address)) continue;
                    ipAddress.append(ip.getHostAddress() + ";");
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return ipAddress.toString();
    }

    public static void main(String[] args) {
        System.out.println(SystemUtil.getIPAddress());
        System.out.println(SystemUtil.getSystemInfo().toString());
    }

    static class SystemStatus
    implements Serializable {
        private String startTime;
        private String os;
        private String cpuCore;
        private String cpuSysUseRate;
        private String cpuUserUseRate;
        private String javaVersion;
        private String memMax;
        private String memUsed;
        private String memAva;
        private String diskMax;
        private String diskAva;
        private String diskUsed;
        private String memJavaMax;
        private String memJavaUsed;
        private String memJavaAva;
        private String activeThreads;

        public String getStartTime() {
            return this.startTime;
        }

        public String getOs() {
            return this.os;
        }

        public String getCpuCore() {
            return this.cpuCore;
        }

        public String getCpuSysUseRate() {
            return this.cpuSysUseRate;
        }

        public String getCpuUserUseRate() {
            return this.cpuUserUseRate;
        }

        public String getJavaVersion() {
            return this.javaVersion;
        }

        public String getMemMax() {
            return this.memMax;
        }

        public String getMemUsed() {
            return this.memUsed;
        }

        public String getMemAva() {
            return this.memAva;
        }

        public String getDiskMax() {
            return this.diskMax;
        }

        public String getDiskAva() {
            return this.diskAva;
        }

        public String getDiskUsed() {
            return this.diskUsed;
        }

        public String getMemJavaMax() {
            return this.memJavaMax;
        }

        public String getMemJavaUsed() {
            return this.memJavaUsed;
        }

        public String getMemJavaAva() {
            return this.memJavaAva;
        }

        public String getActiveThreads() {
            return this.activeThreads;
        }

        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public void setOs(String os) {
            this.os = os;
        }

        public void setCpuCore(String cpuCore) {
            this.cpuCore = cpuCore;
        }

        public void setCpuSysUseRate(String cpuSysUseRate) {
            this.cpuSysUseRate = cpuSysUseRate;
        }

        public void setCpuUserUseRate(String cpuUserUseRate) {
            this.cpuUserUseRate = cpuUserUseRate;
        }

        public void setJavaVersion(String javaVersion) {
            this.javaVersion = javaVersion;
        }

        public void setMemMax(String memMax) {
            this.memMax = memMax;
        }

        public void setMemUsed(String memUsed) {
            this.memUsed = memUsed;
        }

        public void setMemAva(String memAva) {
            this.memAva = memAva;
        }

        public void setDiskMax(String diskMax) {
            this.diskMax = diskMax;
        }

        public void setDiskAva(String diskAva) {
            this.diskAva = diskAva;
        }

        public void setDiskUsed(String diskUsed) {
            this.diskUsed = diskUsed;
        }

        public void setMemJavaMax(String memJavaMax) {
            this.memJavaMax = memJavaMax;
        }

        public void setMemJavaUsed(String memJavaUsed) {
            this.memJavaUsed = memJavaUsed;
        }

        public void setMemJavaAva(String memJavaAva) {
            this.memJavaAva = memJavaAva;
        }

        public void setActiveThreads(String activeThreads) {
            this.activeThreads = activeThreads;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SystemStatus)) {
                return false;
            }
            SystemStatus other = (SystemStatus)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$startTime = this.getStartTime();
            String other$startTime = other.getStartTime();
            if (this$startTime == null ? other$startTime != null : !this$startTime.equals(other$startTime)) {
                return false;
            }
            String this$os = this.getOs();
            String other$os = other.getOs();
            if (this$os == null ? other$os != null : !this$os.equals(other$os)) {
                return false;
            }
            String this$cpuCore = this.getCpuCore();
            String other$cpuCore = other.getCpuCore();
            if (this$cpuCore == null ? other$cpuCore != null : !this$cpuCore.equals(other$cpuCore)) {
                return false;
            }
            String this$cpuSysUseRate = this.getCpuSysUseRate();
            String other$cpuSysUseRate = other.getCpuSysUseRate();
            if (this$cpuSysUseRate == null ? other$cpuSysUseRate != null : !this$cpuSysUseRate.equals(other$cpuSysUseRate)) {
                return false;
            }
            String this$cpuUserUseRate = this.getCpuUserUseRate();
            String other$cpuUserUseRate = other.getCpuUserUseRate();
            if (this$cpuUserUseRate == null ? other$cpuUserUseRate != null : !this$cpuUserUseRate.equals(other$cpuUserUseRate)) {
                return false;
            }
            String this$javaVersion = this.getJavaVersion();
            String other$javaVersion = other.getJavaVersion();
            if (this$javaVersion == null ? other$javaVersion != null : !this$javaVersion.equals(other$javaVersion)) {
                return false;
            }
            String this$memMax = this.getMemMax();
            String other$memMax = other.getMemMax();
            if (this$memMax == null ? other$memMax != null : !this$memMax.equals(other$memMax)) {
                return false;
            }
            String this$memUsed = this.getMemUsed();
            String other$memUsed = other.getMemUsed();
            if (this$memUsed == null ? other$memUsed != null : !this$memUsed.equals(other$memUsed)) {
                return false;
            }
            String this$memAva = this.getMemAva();
            String other$memAva = other.getMemAva();
            if (this$memAva == null ? other$memAva != null : !this$memAva.equals(other$memAva)) {
                return false;
            }
            String this$diskMax = this.getDiskMax();
            String other$diskMax = other.getDiskMax();
            if (this$diskMax == null ? other$diskMax != null : !this$diskMax.equals(other$diskMax)) {
                return false;
            }
            String this$diskAva = this.getDiskAva();
            String other$diskAva = other.getDiskAva();
            if (this$diskAva == null ? other$diskAva != null : !this$diskAva.equals(other$diskAva)) {
                return false;
            }
            String this$diskUsed = this.getDiskUsed();
            String other$diskUsed = other.getDiskUsed();
            if (this$diskUsed == null ? other$diskUsed != null : !this$diskUsed.equals(other$diskUsed)) {
                return false;
            }
            String this$memJavaMax = this.getMemJavaMax();
            String other$memJavaMax = other.getMemJavaMax();
            if (this$memJavaMax == null ? other$memJavaMax != null : !this$memJavaMax.equals(other$memJavaMax)) {
                return false;
            }
            String this$memJavaUsed = this.getMemJavaUsed();
            String other$memJavaUsed = other.getMemJavaUsed();
            if (this$memJavaUsed == null ? other$memJavaUsed != null : !this$memJavaUsed.equals(other$memJavaUsed)) {
                return false;
            }
            String this$memJavaAva = this.getMemJavaAva();
            String other$memJavaAva = other.getMemJavaAva();
            if (this$memJavaAva == null ? other$memJavaAva != null : !this$memJavaAva.equals(other$memJavaAva)) {
                return false;
            }
            String this$activeThreads = this.getActiveThreads();
            String other$activeThreads = other.getActiveThreads();
            return !(this$activeThreads == null ? other$activeThreads != null : !this$activeThreads.equals(other$activeThreads));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SystemStatus;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $startTime = this.getStartTime();
            result = result * 59 + ($startTime == null ? 43 : $startTime.hashCode());
            String $os = this.getOs();
            result = result * 59 + ($os == null ? 43 : $os.hashCode());
            String $cpuCore = this.getCpuCore();
            result = result * 59 + ($cpuCore == null ? 43 : $cpuCore.hashCode());
            String $cpuSysUseRate = this.getCpuSysUseRate();
            result = result * 59 + ($cpuSysUseRate == null ? 43 : $cpuSysUseRate.hashCode());
            String $cpuUserUseRate = this.getCpuUserUseRate();
            result = result * 59 + ($cpuUserUseRate == null ? 43 : $cpuUserUseRate.hashCode());
            String $javaVersion = this.getJavaVersion();
            result = result * 59 + ($javaVersion == null ? 43 : $javaVersion.hashCode());
            String $memMax = this.getMemMax();
            result = result * 59 + ($memMax == null ? 43 : $memMax.hashCode());
            String $memUsed = this.getMemUsed();
            result = result * 59 + ($memUsed == null ? 43 : $memUsed.hashCode());
            String $memAva = this.getMemAva();
            result = result * 59 + ($memAva == null ? 43 : $memAva.hashCode());
            String $diskMax = this.getDiskMax();
            result = result * 59 + ($diskMax == null ? 43 : $diskMax.hashCode());
            String $diskAva = this.getDiskAva();
            result = result * 59 + ($diskAva == null ? 43 : $diskAva.hashCode());
            String $diskUsed = this.getDiskUsed();
            result = result * 59 + ($diskUsed == null ? 43 : $diskUsed.hashCode());
            String $memJavaMax = this.getMemJavaMax();
            result = result * 59 + ($memJavaMax == null ? 43 : $memJavaMax.hashCode());
            String $memJavaUsed = this.getMemJavaUsed();
            result = result * 59 + ($memJavaUsed == null ? 43 : $memJavaUsed.hashCode());
            String $memJavaAva = this.getMemJavaAva();
            result = result * 59 + ($memJavaAva == null ? 43 : $memJavaAva.hashCode());
            String $activeThreads = this.getActiveThreads();
            result = result * 59 + ($activeThreads == null ? 43 : $activeThreads.hashCode());
            return result;
        }

        public String toString() {
            return "SystemUtil.SystemStatus(startTime=" + this.getStartTime() + ", os=" + this.getOs() + ", cpuCore=" + this.getCpuCore() + ", cpuSysUseRate=" + this.getCpuSysUseRate() + ", cpuUserUseRate=" + this.getCpuUserUseRate() + ", javaVersion=" + this.getJavaVersion() + ", memMax=" + this.getMemMax() + ", memUsed=" + this.getMemUsed() + ", memAva=" + this.getMemAva() + ", diskMax=" + this.getDiskMax() + ", diskAva=" + this.getDiskAva() + ", diskUsed=" + this.getDiskUsed() + ", memJavaMax=" + this.getMemJavaMax() + ", memJavaUsed=" + this.getMemJavaUsed() + ", memJavaAva=" + this.getMemJavaAva() + ", activeThreads=" + this.getActiveThreads() + ")";
        }
    }
}

