/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.utils;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UnicodeUtils {
    private static Logger logger = LoggerFactory.getLogger(UnicodeUtils.class);
    private static final Charset UTF8 = Charset.forName("UTF-8");
    public static final String US_ASCII = "US-ASCII";
    public static final String ISO_8859_1 = "ISO-8859-1";
    public static final String UTF_8 = "UTF-8";
    public static final String UTF_16BE = "UTF-16BE";
    public static final String UTF_16LE = "UTF-16LE";
    public static final String UTF_16 = "UTF-16";
    public static final String GBK = "GBK";

    public String toASCII(String str) throws UnsupportedEncodingException {
        return this.changeCharset(str, US_ASCII);
    }

    public String toISO_8859_1(String str) throws UnsupportedEncodingException {
        return this.changeCharset(str, ISO_8859_1);
    }

    public String toUTF_8(String str) throws UnsupportedEncodingException {
        return this.changeCharset(str, UTF_8);
    }

    public String toUTF_16BE(String str) throws UnsupportedEncodingException {
        return this.changeCharset(str, UTF_16BE);
    }

    public String toUTF_16LE(String str) throws UnsupportedEncodingException {
        return this.changeCharset(str, UTF_16LE);
    }

    public String toUTF_16(String str) throws UnsupportedEncodingException {
        return this.changeCharset(str, UTF_16);
    }

    public String toGBK(String str) throws UnsupportedEncodingException {
        return this.changeCharset(str, GBK);
    }

    public String changeCharset(String str, String newCharset) throws UnsupportedEncodingException {
        if (str != null) {
            byte[] bs = str.getBytes();
            return new String(bs, newCharset);
        }
        return null;
    }

    public String changeCharset(String str, String oldCharset, String newCharset) throws UnsupportedEncodingException {
        if (str != null) {
            byte[] bs = str.getBytes(oldCharset);
            return new String(bs, newCharset);
        }
        return null;
    }

    public static boolean isContainsMb4Char(String input) {
        if (input == null) {
            return false;
        }
        byte[] bytes = input.getBytes(UTF8);
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            if ((b & 0xF0) == 240) {
                return true;
            }
            if ((b & 0xE0) == 224) {
                i += 2;
                continue;
            }
            if ((b & 0xC0) != 192) continue;
            ++i;
        }
        return false;
    }

    public static String replMb4Char(String input, String replacement) {
        if (input == null) {
            throw new IllegalArgumentException("input can not be null when replaceMb4Char");
        }
        StringBuilder sb = new StringBuilder(input.length());
        byte[] bytes = input.getBytes(UTF8);
        char[] chars = input.toCharArray();
        int charIdx = 0;
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            if ((b & 0xF0) == 240) {
                sb.append(replacement);
                charIdx += 2;
                i += 3;
                continue;
            }
            if ((b & 0xE0) == 224) {
                i += 2;
            } else if ((b & 0xC0) == 192) {
                ++i;
            }
            sb.append(chars[charIdx]);
            ++charIdx;
        }
        return sb.toString();
    }

    public static boolean isMyEncoding(String input, String EncodingStr) {
        try {
            if (input.equals(new String(input.getBytes(EncodingStr), EncodingStr))) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return false;
        }
        return false;
    }

    public static void main(String[] args) throws Exception {
        UnicodeUtils test = new UnicodeUtils();
        String str = "This is a \u4e2d\u6587\u7684 String!";
        String gbk = new String(str.getBytes(), GBK);
        System.out.println(new String(gbk.getBytes(), UTF_8));
        System.out.println(new String(str.getBytes("GB2312"), "GB2312"));
        System.out.println(UnicodeUtils.isMyEncoding(str, "GB2312"));
    }
}

