/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.utils;

import com.xforceplus.apollo.msg.SealedMessage;
import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.apollo.utils.FileBytesUtil;
import com.xforceplus.apollo.utils.IOUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtil {
    private static Logger logger = LoggerFactory.getLogger(ZipUtil.class);
    public static final String CLIENT_CLAZZ_NAME = "clazzName";
    public static final String BOOL_TRUE = "true";
    public static final String CLIENT_BIG_DATA_COMPRESS = "bigDataCompress";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File doZip(String filePath) {
        File target = null;
        File source = new File(filePath);
        if (source.exists()) {
            String zipName = source.getName() + ".zip";
            target = new File(source.getParent(), zipName);
            if (target.exists()) {
                target.delete();
            }
            FileOutputStream fos = null;
            ZipOutputStream zos = null;
            try {
                fos = new FileOutputStream(target);
                zos = new ZipOutputStream(new BufferedOutputStream(fos));
                ZipUtil.addEntry("/", source, zos);
            }
            catch (IOException e) {
                try {
                    logger.error(ErrorUtil.getStackMsg(e));
                }
                catch (Throwable throwable) {
                    IOUtil.closeQuietly(zos, fos);
                    throw throwable;
                }
                IOUtil.closeQuietly(zos, fos);
            }
            IOUtil.closeQuietly(zos, fos);
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void addEntry(String base, File source, ZipOutputStream zos) throws IOException {
        String entry = base + source.getName();
        if (source.isDirectory()) {
            File[] fileArray = source.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                ZipUtil.addEntry(entry + "/", file, zos);
                ++n2;
            }
            return;
        }
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            byte[] buffer = new byte[10240];
            fis = new FileInputStream(source);
            bis = new BufferedInputStream(fis, buffer.length);
            int read = 0;
            zos.putNextEntry(new ZipEntry(entry));
            while ((read = bis.read(buffer, 0, buffer.length)) != -1) {
                zos.write(buffer, 0, read);
            }
            zos.closeEntry();
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly(bis, fis);
            throw throwable;
        }
        IOUtil.closeQuietly(bis, fis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> unzip(String filePath) {
        File source = new File(filePath);
        ArrayList<String> targetPaths = new ArrayList<String>();
        if (source.exists()) {
            ZipInputStream zis = null;
            BufferedOutputStream bos = null;
            try {
                zis = new ZipInputStream(new FileInputStream(source));
                ZipEntry entry = null;
                while ((entry = zis.getNextEntry()) != null && !entry.isDirectory()) {
                    File target = new File(source.getParent(), entry.getName());
                    if (!target.getParentFile().exists()) {
                        target.getParentFile().mkdirs();
                    }
                    bos = new BufferedOutputStream(new FileOutputStream(target));
                    int read = 0;
                    byte[] buffer = new byte[10240];
                    while ((read = zis.read(buffer, 0, buffer.length)) != -1) {
                        bos.write(buffer, 0, read);
                    }
                    targetPaths.add(target.getPath());
                    bos.flush();
                    bos.close();
                }
                zis.closeEntry();
            }
            catch (IOException e) {
                try {
                    logger.error(ErrorUtil.getStackMsg(e));
                }
                catch (Throwable throwable) {
                    IOUtil.closeQuietly(zis, bos);
                    throw throwable;
                }
                IOUtil.closeQuietly(zis, bos);
            }
            IOUtil.closeQuietly(zis, bos);
        }
        return targetPaths;
    }

    public static SealedMessage decompress(SealedMessage sealedMessage) {
        SealedMessage resultMessage = null;
        try {
            if (BOOL_TRUE.equals(sealedMessage.getHeader().getOthers().get(CLIENT_BIG_DATA_COMPRESS)) && null != sealedMessage.getPayload() && null != sealedMessage.getPayload().getObj()) {
                byte[] oriBytes;
                byte[] compressBytes;
                String hexString = sealedMessage.getPayload().getObj().toString();
                if (StringUtils.isNotBlank((CharSequence)hexString) && null != (compressBytes = FileBytesUtil.hexStringToByte(hexString)) && compressBytes.length > 0 && null != (oriBytes = FileBytesUtil.unjzlib(compressBytes)) && oriBytes.length > 0) {
                    String oriString = new String(oriBytes);
                    sealedMessage.getHeader().getOthers().remove(CLIENT_BIG_DATA_COMPRESS);
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)sealedMessage.getHeader().getOthers().get(CLIENT_CLAZZ_NAME)))) {
                        try {
                            Class<?> clazz = Class.forName((String)sealedMessage.getHeader().getOthers().get(CLIENT_CLAZZ_NAME));
                            sealedMessage.getHeader().getOthers().remove(CLIENT_CLAZZ_NAME);
                            resultMessage = new SealedMessage(sealedMessage.getHeader(), new SealedMessage.Payload(JacksonUtil.getInstance().fromJson(oriString, clazz)));
                        }
                        catch (ClassNotFoundException e) {
                            resultMessage = new SealedMessage(sealedMessage.getHeader(), new SealedMessage.Payload((Object)oriString));
                        }
                    } else {
                        resultMessage = new SealedMessage(sealedMessage.getHeader(), new SealedMessage.Payload((Object)oriString));
                    }
                }
            } else {
                resultMessage = (SealedMessage)SerializationUtils.clone((Serializable)sealedMessage);
            }
        }
        catch (Exception e) {
            logger.error(ErrorUtil.getStackMsg(e));
        }
        return resultMessage;
    }

    public static SealedMessage compress(SealedMessage sealedMessage) {
        SealedMessage resultMessage = null;
        if (null != sealedMessage.getPayload() && null != sealedMessage.getPayload().getObj() && StringUtils.isBlank((CharSequence)((CharSequence)sealedMessage.getHeader().getOthers().get(CLIENT_BIG_DATA_COMPRESS)))) {
            String payload_str;
            if (sealedMessage.getPayload().getObj() instanceof String) {
                payload_str = sealedMessage.getPayload().getObj().toString();
            } else {
                payload_str = JacksonUtil.getInstance().toJson(sealedMessage.getPayload().getObj());
                sealedMessage.getHeader().getOthers().put(CLIENT_CLAZZ_NAME, sealedMessage.getPayload().getObj().getClass().getName());
            }
            if (payload_str.length() > 102400) {
                try {
                    byte[] bytes = FileBytesUtil.jzlib(payload_str.getBytes());
                    if (bytes.length > 0x100000) {
                        logger.error("msgId:{} \u538b\u7f29\u540e\u6587\u4ef6\u5b57\u8282\u8fc7\u5927:{},\u6d88\u606f\u5185\u5bb9:{}", new Object[]{sealedMessage.getHeader().getMsgId(), bytes.length, JacksonUtil.getInstance().toJson(sealedMessage)});
                    } else {
                        String hexString = FileBytesUtil.bytesToHexString(bytes);
                        if (StringUtils.isNotBlank((CharSequence)hexString)) {
                            sealedMessage.getHeader().getOthers().put(CLIENT_BIG_DATA_COMPRESS, BOOL_TRUE);
                            resultMessage = new SealedMessage(sealedMessage.getHeader(), new SealedMessage.Payload((Object)hexString));
                        }
                    }
                }
                catch (Exception e) {
                    logger.info("msgId:{} \u538b\u7f29\u5f02\u5e38:{},\u6d88\u606f\u5185\u5bb9:{}", new Object[]{sealedMessage.getHeader().getMsgId(), ErrorUtil.getStackMsg(e), JacksonUtil.getInstance().toJson(sealedMessage)});
                }
            } else {
                resultMessage = (SealedMessage)SerializationUtils.clone((Serializable)sealedMessage);
            }
        } else {
            resultMessage = sealedMessage;
        }
        return resultMessage;
    }

    public static void main(String[] args) throws Exception {
        SealedMessage sealedMessage = JacksonUtil.getInstance().fromJson("{\"header\":{\"userId\":\"1803c97e-f4c2-419e-8dc1-20457b18f997\",\"requestName\":\"keepAlived1\",\"others\":{\"athena_sellerTenantCode\":\"Watsons\",\"athena_transmissionMode\":\"through\",\"clientAddress\":\"101.37.80.234:48658\",\"payLoadId\":\"101.37.80.234:48658\",\"interfaceType\":\"EDCBus\",\"athena_purcharserTenantCode\":\"\",\"ApolloSellerName\":\"\u5e7f\u5dde\u5c48\u81e3\u6c0f\u4e2a\u4eba\u7528\u54c1\u5546\u5e97\u6709\u9650\u516c\u53f8\",\"pdfUrl\":\"http://101.37.174.74:8080/litchi/pdf/downloadFile.jsp?request=iNwCBxYT9HHeA%2FNTy7%2BfGsdAAAhmLfYtWwPvG%2BWpUNRp89Znuw20t1OaudgMatadtVE%2BLXJW6Vbl%0AHajRH%2Ft9Gw5rRErbuAcyrnt5uPyB5aISK2Egp%2B6Wab4psu%2Fn90CpN0hWDkL92%2Fp26capBMoFOavi%0AlDJf6WUG0rffJWIakPUx%2B6q6ZRdWRg%3D%3D\",\"athena_businessNo\":\"10814010\",\"905sellerInvoicePush\":\"[\\\"901##sellerInvoicePush\\\",\\\"62d63462-ceb2-4d10-a25b-bc84bd815bac##sellerInvoicePush\\\",\\\"560605a0-3539-4c5c-8fb4-3192e3127564##sellerInvoicePush\\\",\\\"8856fa10-3f95-478c-9580-486924e1686e##sellerInvoicePush\\\",\\\"b8e52d97-05ab-4bbd-bf49-3234fee5538d##sellerInvoicePush\\\",\\\"696117aa-6bac-414e-9209-da91fa14d904##sellerInvoicePush\\\"]\",\"athena_interfaceType\":\"invoiceSellerPush\",\"athena_purchaserCode\":\"\",\"athena_sellerCode\":\"AWJQP55293\",\"groupFlag\":\"Watsons\",\"athena_businessId\":\"e1f04dc8-1736-4291-b97f-49d9d2cc85c3\"},\"msgId\":\"0496685a-2f56-4fc6-af8e-339d8cdbce6f_905\",\"createTime\":\"2017-08-14 18:09:36\",\"type\":\"data\",\"payLoadId\":null},\"payload\":{\"obj\":\"{\\\"sellerInvoiceMain\\\":{\\\"invoicerName\\\":\\\"\u5c48\u81e3\u6c0f\\\",\\\"purchaserBankAccount\\\":\\\"\\\",\\\"sellerName\\\":\\\"\u5e7f\u5dde\u5c48\u81e3\u6c0f\u4e2a\u4eba\u7528\u54c1\u5546\u5e97\u6709\u9650\u516c\u53f8\\\",\\\"sellerNo\\\":\\\"6003\\\",\\\"sellerAddress\\\":\\\"\u5e7f\u5dde\u5e02\u7ecf\u6d4e\u6280\u672f\u5f00\u53d1\u533a\u9526\u7ee3\u8def38\u53f7\\\",\\\"remark\\\":\\\"\\\",\\\"tenantCode\\\":\\\"Watsons\\\",\\\"purchaserAddress\\\":\\\"\\\",\\\"purchaserNo\\\":\\\"\\\",\\\"purchaserBankInfo\\\":\\\" \\\",\\\"sellerBankInfo\\\":\\\"\u62db\u5546\u94f6\u884c\u80a1\u4efd\u6709\u9650\u516c\u53f8\u5e7f\u5dde\u6d77\u73e0\u652f\u884c 123456789\\\",\\\"sellerAddrTel\\\":\\\"\u5e7f\u5dde\u5e02\u7ecf\u6d4e\u6280\u672f\u5f00\u53d1\u533a\u9526\u7ee3\u8def38\u53f7 020-28336915\\\",\\\"redNotificationNo\\\":\\\" \\\",\\\"invoiceType\\\":\\\"ce\\\",\\\"sellerTel\\\":\\\"020-28336915\\\",\\\"invoiceNo\\\":\\\"10814010\\\",\\\"cashierName\\\":\\\"\u6d4b\u8bd51\\\",\\\"originInvoiceCode\\\":\\\"\\\",\\\"amountWithoutTax\\\":330.0,\\\"settlementNo\\\":\\\"20170814180928444SQK\\\",\\\"purchaserTel\\\":\\\"\\\",\\\"invoiceCode\\\":\\\"3100012345\\\",\\\"purchaserName\\\":\\\"\u5c48\u81e3\u6c0f\\\",\\\"purchaserBankName\\\":\\\"\\\",\\\"taxRate\\\":10.6,\\\"sellerTaxNo\\\":\\\"914401016184216161\\\",\\\"purchaserTaxNo\\\":\\\"123456789987654\\\",\\\"originInvoiceNo\\\":\\\"\\\",\\\"sellerBankAccount\\\":\\\"123456789\\\",\\\"purchaserAddrTel\\\":\\\"\\\",\\\"paperDrewDate\\\":\\\"20170814\\\",\\\"checkerName\\\":\\\"\u6d4b\u8bd52\\\",\\\"taxAmount\\\":31.64,\\\"amountWithTax\\\":330.0,\\\"sellerBankName\\\":\\\"\u62db\u5546\u94f6\u884c\u80a1\u4efd\u6709\u9650\u516c\u53f8\u5e7f\u5dde\u6d77\u73e0\u652f\u884c\\\",\\\"status\\\":\\\"1\\\",\\\"eUrl\\\":\\\"http://101.37.174.74:8080/litchi/pdf/downloadFile.jsp?request=iNwCBxYT9HHeA%2FNTy7%2BfGsdAAAhmLfYtWwPvG%2BWpUNRp89Znuw20t1OaudgMatadtVE%2BLXJW6Vbl%0AHajRH%2Ft9Gw5rRErbuAcyrnt5uPyB5aISK2Egp%2B6Wab4psu%2Fn90CpN0hWDkL92%2Fp26capBMoFOavi%0AlDJf6WUG0rffJWIakPUx%2B6q6ZRdWRg%3D%3D\\\"},\\\"sellerInvoiceDetails\\\":[{\\\"unitPrice\\\":100,\\\"amountWithoutTax\\\":100.0,\\\"itemSpec\\\":\\\"\\\",\\\"quantity\\\":1.0,\\\"goodsTaxNo\\\":\\\"6010000000000000000\\\",\\\"cargoCode\\\":\\\"\\\",\\\"settlementItemId\\\":\\\"20170814180928444SQK0007\\\",\\\"quantityUnit\\\":\\\"\\\",\\\"deductions\\\":0.0,\\\"taxRate\\\":0.0,\\\"cargoName\\\":\\\"\u9884\u4ed8\u5361100\u51432017\u7248\\\",\\\"taxAmount\\\":0.0,\\\"amountWithTax\\\":100.0},{\\\"unitPrice\\\":17.09,\\\"amountWithoutTax\\\":17.09,\\\"itemSpec\\\":\\\"\\\",\\\"quantity\\\":1.0,\\\"goodsTaxNo\\\":\\\"1070223020000000000\\\",\\\"cargoCode\\\":\\\"\\\",\\\"settlementItemId\\\":\\\"20170814180928444SQK0006\\\",\\\"quantityUnit\\\":\\\"\\\",\\\"deductions\\\":0.0,\\\"taxRate\\\":17.0,\\\"cargoName\\\":\\\"\u5170\u4fac\u80ce\u76d8\u86cb\u767d\u62a4\u80a4\u4e73\u6db2\\\",\\\"taxAmount\\\":2.91,\\\"amountWithTax\\\":20.0},{\\\"unitPrice\\\":51.28,\\\"amountWithoutTax\\\":51.28,\\\"itemSpec\\\":\\\"\\\",\\\"quantity\\\":1.0,\\\"goodsTaxNo\\\":\\\"1070301190000000000\\\",\\\"cargoCode\\\":\\\"\\\",\\\"settlementItemId\\\":\\\"20170814180928444SQK0005\\\",\\\"quantityUnit\\\":\\\"\\\",\\\"deductions\\\":0.0,\\\"taxRate\\\":17.0,\\\"cargoName\\\":\\\"\u6ef4\u9732\u6d88\u6bd2\u836f\u6c341200\u6beb\u5347\\\",\\\"taxAmount\\\":8.72,\\\"amountWithTax\\\":60.0},{\\\"unitPrice\\\":18.87,\\\"amountWithoutTax\\\":18.87,\\\"itemSpec\\\":\\\"\\\",\\\"quantity\\\":1.0,\\\"goodsTaxNo\\\":\\\"3079900000000000000\\\",\\\"cargoCode\\\":\\\"\\\",\\\"settlementItemId\\\":\\\"20170814180928444SQK0004\\\",\\\"quantityUnit\\\":\\\"\\\",\\\"deductions\\\":0.0,\\\"taxRate\\\":6.0,\\\"cargoName\\\":\\\"\u4f1a\u5458\u8d39-\u7b2c\u4e8c\u7248\u4f1a\u5458\u5361\\\",\\\"taxAmount\\\":1.13,\\\"amountWithTax\\\":20.0},{\\\"unitPrice\\\":8.55,\\\"amountWithoutTax\\\":8.55,\\\"itemSpec\\\":\\\"\\\",\\\"quantity\\\":1.0,\\\"goodsTaxNo\\\":\\\"1030201030000000000\\\",\\\"cargoCode\\\":\\\"\\\",\\\"settlementItemId\\\":\\\"20170814180928444SQK0003\\\",\\\"quantityUnit\\\":\\\"\\\",\\\"deductions\\\":0.0,\\\"taxRate\\\":17.0,\\\"cargoName\\\":\\\"\u96c0\u5de2\u5947\u5de7\u9ed1\u5de7\u514b\u529b\u56db\u6307\u4e8c\u724735\u514bX2\\\",\\\"taxAmount\\\":1.45,\\\"amountWithTax\\\":10.0},{\\\"unitPrice\\\":34.19,\\\"amountWithoutTax\\\":34.19,\\\"itemSpec\\\":\\\"\\\",\\\"quantity\\\":1.0,\\\"goodsTaxNo\\\":\\\"1070223040000000000\\\",\\\"cargoCode\\\":\\\"\\\",\\\"settlementItemId\\\":\\\"20170814180928444SQK0002\\\",\\\"quantityUnit\\\":\\\"\\\",\\\"deductions\\\":0.0,\\\"taxRate\\\":17.0,\\\"cargoName\\\":\\\"\u9732\u534e\u6d53\u4e30\u598d\u8bf1\u543b\u5507\u818f80024522 4\u514b\\\",\\\"taxAmount\\\":5.81,\\\"amountWithTax\\\":40.0},{\\\"unitPrice\\\":25.64,\\\"amountWithoutTax\\\":25.64,\\\"itemSpec\\\":\\\"\\\",\\\"quantity\\\":1.0,\\\"goodsTaxNo\\\":\\\"1060512990000000000\\\",\\\"cargoCode\\\":\\\"\\\",\\\"settlementItemId\\\":\\\"20170814180928444SQK0001\\\",\\\"quantityUnit\\\":\\\"\\\",\\\"deductions\\\":0.0,\\\"taxRate\\\":17.0,\\\"cargoName\\\":\\\"\u7f8e\u59ae\u76db\u5bb4\u624b\u673a\u94fe(\u624b\u94fe\u578b)\\\",\\\"taxAmount\\\":4.36,\\\"amountWithTax\\\":30.0},{\\\"unitPrice\\\":42.74,\\\"amountWithoutTax\\\":42.74,\\\"itemSpec\\\":\\\"\\\",\\\"quantity\\\":1.0,\\\"goodsTaxNo\\\":\\\"1030208990000000000\\\",\\\"cargoCode\\\":\\\"\\\",\\\"settlementItemId\\\":\\\"20170814180928444SQK0000\\\",\\\"quantityUnit\\\":\\\"\\\",\\\"deductions\\\":0.0,\\\"taxRate\\\":17.0,\\\"cargoName\\\":\\\"\u767d\u5170\u6c0f\u4f20\u7edf\u9e21\u7cbe\u7cbe\u81f4\u793c\u76d2\u88c568\u6beb\u5347*4\\\",\\\"taxAmount\\\":7.26,\\\"amountWithTax\\\":50.0}]}\"}}", SealedMessage.class);
        int i = 0;
        while (true) {
            SealedMessage resultMessage = (SealedMessage)SerializationUtils.clone((Serializable)sealedMessage);
            if (++i % 100 != 0) continue;
            System.out.println(JacksonUtil.getInstance().toJson(resultMessage));
        }
    }
}

