/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.utils.business;

import com.xforceplus.apollo.utils.business.InvoiceType;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvoiceChecker {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    private InvoiceChecker() {
    }

    public static InvoiceChecker build() {
        return new InvoiceChecker();
    }

    public InvoiceType checkType(String invoiceCode) {
        InvoiceType type;
        int size = StringUtils.length((CharSequence)invoiceCode);
        try {
            type = (InvoiceType)((Object)MethodUtils.invokeMethod((Object)this, (boolean)true, (String)("check" + size + "CodeType"), (Object[])new Object[]{invoiceCode}, (Class[])new Class[]{String.class}));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            this.logger.warn("{} \u53d1\u7968\u7c7b\u578b\u89e3\u6790\u5931\u8d25", (Object)invoiceCode, (Object)e);
            type = InvoiceType.UNKNOW;
        }
        return type;
    }

    protected InvoiceType check10CodeType(String invoiceCode) {
        char ch = invoiceCode.charAt(7);
        InvoiceType type = null;
        switch (ch) {
            case '1': 
            case '5': {
                type = InvoiceType.SPECIAL_INVOICE;
                break;
            }
            case '3': 
            case '6': {
                type = InvoiceType.PLAIN_INVOICE;
                break;
            }
            case '2': 
            case '7': {
                type = InvoiceType.FREIGHT_SPECIAL_INVOICE;
                break;
            }
            default: {
                type = InvoiceType.UNKNOW;
            }
        }
        return type;
    }

    protected InvoiceType check12CodeType(String invoiceCode) {
        InvoiceType type = null;
        char fch = invoiceCode.charAt(0);
        try {
            type = (InvoiceType)((Object)MethodUtils.invokeMethod((Object)this, (boolean)true, (String)("check12CodeType" + fch + "Ex"), (Object[])new Object[]{invoiceCode}, (Class[])new Class[]{String.class}));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            this.logger.warn("{} \u53d1\u7968\u7c7b\u578b\u89e3\u6790\u5931\u8d25", (Object)invoiceCode, (Object)e);
            type = InvoiceType.UNKNOW;
        }
        return type;
    }

    protected InvoiceType check12CodeType0Ex(String invoiceCode) {
        String str;
        InvoiceType type = null;
        switch (str = StringUtils.substring((String)invoiceCode, (int)10)) {
            case "11": {
                type = InvoiceType.ELECTRONIC_PLAIN_INVOICE;
                break;
            }
            case "12": {
                type = InvoiceType.TOLL_ELECTRONIC_ORDINARY_INVOICE;
                break;
            }
            case "04": 
            case "05": {
                type = InvoiceType.FOLD_PLAIN_INVOICE;
                break;
            }
            case "06": 
            case "07": {
                type = InvoiceType.ROLL_PLAIN_INVOICE;
                break;
            }
            default: {
                type = InvoiceType.UNKNOW;
            }
        }
        return type;
    }

    protected InvoiceType check12CodeType1Ex(String invoiceCode) {
        InvoiceType type = null;
        char ch8 = invoiceCode.charAt(7);
        String str = StringUtils.substring((String)invoiceCode, (int)10);
        type = ch8 == '2' ? InvoiceType.MOTOR_VEHICLES_UNIFORM_INVOICE : (StringUtils.equals((CharSequence)str, (CharSequence)"17") ? InvoiceType.USED_CAR_SALES_UNIFORM_INVOICE : (StringUtils.equals((CharSequence)str, (CharSequence)"26") ? InvoiceType.COLUMN_INVOICE : InvoiceType.UNKNOW));
        return type;
    }

    public static void main(String[] args) {
        InvoiceChecker checker = InvoiceChecker.build();
        InvoiceType type = checker.checkType("1234567800");
        System.out.println((Object)type);
        type = checker.checkType("031001700311");
        System.out.println((Object)type);
    }
}

