/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.utils.code;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.xforceplus.apollo.utils.JacksonUtil;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldCopyUtils {
    private static Logger logger = LoggerFactory.getLogger(FieldCopyUtils.class);

    public static void copyFields(Object src, Object target) {
        Preconditions.checkArgument((boolean)ObjectUtils.allNotNull((Object[])new Object[]{src, target}), (Object)"\u5c5e\u6027\u8d4b\u503c (\u6e90-\u76ee\u6807) \u672a\u6307\u5b9a!");
        Field[] srcAttrs = FieldUtils.getAllFields(src.getClass());
        Field[] tarAttrs = FieldUtils.getAllFields(target.getClass());
        int srcSize = ArrayUtils.getLength((Object)srcAttrs);
        int tarSize = ArrayUtils.getLength((Object)tarAttrs);
        if (srcSize != 0 && tarSize != 0) {
            Map<String, Field> srcMattrs = Arrays.stream(srcAttrs).collect(Collectors.toMap(Field::getName, field -> field, (s, a) -> s));
            Map<String, Field> tarMattrs = Arrays.stream(tarAttrs).collect(Collectors.toMap(Field::getName, field -> field, (s, a) -> s));
            StringJoiner sj = new StringJoiner(",");
            srcMattrs.forEach((k, v) -> {
                Field field = (Field)tarMattrs.get(k);
                if (field != null && field.getType().equals(v.getType())) {
                    field.setAccessible(true);
                    v.setAccessible(true);
                    try {
                        field.set(target, v.get(src));
                    }
                    catch (IllegalAccessException e) {
                        sj.add((CharSequence)k);
                    }
                }
            });
            String str = sj.toString();
            if (StringUtils.isNotEmpty((CharSequence)str)) {
                logger.warn("{} > {} \u5c5e\u6027copy\u5931\u8d25\uff1a{}", new Object[]{src.getClass(), target.getClass(), str});
            }
        }
    }

    public static Map<String, String> beanMap(Object obj) {
        JacksonUtil jsonUtil = JacksonUtil.getInstance();
        Map map = null;
        String sjon = jsonUtil.toJson(obj);
        map = jsonUtil.fromJson(sjon, Map.class);
        return map == null ? Maps.newHashMap() : map;
    }
}

