/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.utils.code;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.Charsets;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class GZipUtils {
    public static final String UTF_8 = "UTF-8";
    public static final String ISO_8859_1 = "ISO-8859-1";
    public static final String GBK = "GBK";

    public static byte[] gzip(byte[] bytes) throws IOException {
        if (ArrayUtils.isEmpty((byte[])bytes)) {
            return null;
        }
        byte[] bs = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(bos);
        gzip.write(bytes);
        gzip.flush();
        gzip.close();
        bs = bos.toByteArray();
        bos.close();
        return bs;
    }

    public static byte[] gzip(String str) throws IOException {
        return GZipUtils.gzip(str, UTF_8);
    }

    public static byte[] gzip(String str, String encoding) throws IOException {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return null;
        }
        return GZipUtils.gzip(str.getBytes(encoding));
    }

    public static byte[] ungzip(byte[] bytes) throws IOException {
        int n;
        if (ArrayUtils.isEmpty((byte[])bytes)) {
            return null;
        }
        byte[] bs = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        GZIPInputStream gzip = new GZIPInputStream(bis);
        byte[] buffer = new byte[1024];
        while ((n = gzip.read(buffer)) != -1) {
            bos.write(buffer, 0, n);
        }
        gzip.close();
        bis.close();
        bs = bos.toByteArray();
        bos.flush();
        bos.close();
        return bs;
    }

    public static String ungzip2str(byte[] bytes) throws IOException {
        return GZipUtils.ungzip2str(bytes, UTF_8);
    }

    public static String ungzip2str(byte[] bytes, String encoding) throws IOException {
        return new String(GZipUtils.ungzip(bytes), Charsets.toCharset((String)encoding));
    }
}

