/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.utils.extend;

import com.xforceplus.apollo.utils.DateFormatUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.helpers.CountingQuietWriter;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggingEvent;

public class XDailyRollingFileAppender
extends FileAppender {
    static final int TOP_OF_TROUBLE = -1;
    static final int TOP_OF_MINUTE = 0;
    static final int TOP_OF_HOUR = 1;
    static final int HALF_DAY = 2;
    static final int TOP_OF_DAY = 3;
    static final int TOP_OF_WEEK = 4;
    static final int TOP_OF_MONTH = 5;
    static final int BUFFER_GZIP = 0x200000;
    static final String SUFFIX_GZIP = ".gz";
    protected long maxFileSize = 0xA00000L;
    protected int maxBackupIndex = 1;
    protected int reserved = 15;
    private String datePattern = "'.'yyyy-MM-dd";
    private String scheduledFilename;
    private String suffix;
    private long nextCheck = System.currentTimeMillis() - 1L;
    Date now = new Date();
    SimpleDateFormat sdf;
    ApolloRollingCalendar rc = new ApolloRollingCalendar();
    int checkPeriod = -1;
    static final TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");
    private static Boolean isInit = false;

    private void initOne() {
        PropertyConfigurator.configureAndWatch((String)(System.getProperty("user.dir") + File.separator + "log4j.properties"), (long)6000L);
    }

    public XDailyRollingFileAppender() {
        if (!isInit.booleanValue()) {
            isInit = true;
            this.initOne();
        }
    }

    public XDailyRollingFileAppender(Layout layout, String filename, String datePattern) throws IOException {
        super(layout, filename, true);
        this.datePattern = datePattern;
        this.activateOptions();
    }

    public XDailyRollingFileAppender(Layout layout, String filename, String datePattern, int reserved) throws IOException {
        super(layout, filename, true);
        this.datePattern = datePattern;
        this.reserved = reserved;
        this.activateOptions();
    }

    public long getMaximumFileSize() {
        return this.maxFileSize;
    }

    public void setMaximumFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public void setMaxFileSize(String value) {
        this.maxFileSize = OptionConverter.toFileSize((String)value, (long)(this.maxFileSize + 1L));
    }

    public int getMaxBackupIndex() {
        return this.maxBackupIndex;
    }

    public void setMaxBackupIndex(int maxBackups) {
        this.maxBackupIndex = maxBackups;
    }

    public int getReserved() {
        return this.reserved;
    }

    public void setReserved(int reserved) {
        this.reserved = reserved;
    }

    public void setDatePattern(String pattern) {
        this.datePattern = pattern;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void activateOptions() {
        super.activateOptions();
        if (this.datePattern != null && this.fileName != null) {
            this.now.setTime(System.currentTimeMillis());
            this.sdf = new SimpleDateFormat(this.datePattern);
            int type = this.computeCheckPeriod();
            this.printPeriodicity(type);
            this.rc.setType(type);
            File file = new File(this.fileName);
            this.scheduledFilename = this.fileName + this.sdf.format(new Date(file.lastModified())) + SUFFIX_GZIP;
        } else {
            LogLog.error((String)("Either File or DatePattern options are not set for appender [" + this.name + "]."));
        }
    }

    void printPeriodicity(int type) {
        switch (type) {
            case 0: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled every minute."));
                break;
            }
            case 1: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled on top of every hour."));
                break;
            }
            case 2: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at midday and midnight."));
                break;
            }
            case 3: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at midnight."));
                break;
            }
            case 4: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at start of week."));
                break;
            }
            case 5: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at start of every month."));
                break;
            }
            default: {
                LogLog.warn((String)("Unknown periodicity for appender [" + this.name + "]."));
            }
        }
    }

    int computeCheckPeriod() {
        ApolloRollingCalendar rollingCalendar = new ApolloRollingCalendar(gmtTimeZone, Locale.ENGLISH);
        Date epoch = new Date(0L);
        if (this.datePattern != null) {
            for (int i = 0; i <= 5; ++i) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.datePattern);
                simpleDateFormat.setTimeZone(gmtTimeZone);
                String r0 = simpleDateFormat.format(epoch);
                rollingCalendar.setType(i);
                Date next = new Date(rollingCalendar.getNextCheckMillis(epoch));
                String r1 = simpleDateFormat.format(next);
                if (r0 == null || r1 == null || r0.equals(r1)) continue;
                return i;
            }
        }
        return -1;
    }

    public void sizeRollOver() {
        int i;
        LogLog.debug((String)("rolling over count=" + ((CountingQuietWriter)this.qw).getCount()));
        LogLog.debug((String)("maxBackupIndex=" + this.maxBackupIndex));
        String datedFilename = this.fileName + this.sdf.format(this.now);
        if (this.maxBackupIndex > 0) {
            File target;
            File file = new File(datedFilename + '.' + this.maxBackupIndex);
            if (file.exists()) {
                file.delete();
            }
            for (i = this.maxBackupIndex - 1; i >= 1; --i) {
                file = new File(datedFilename + "." + i);
                if (!file.exists()) continue;
                target = new File(datedFilename + '.' + (i + 1));
                LogLog.debug((String)("Renaming file " + file + " to " + target));
                file.renameTo(target);
            }
            target = new File(datedFilename + "." + 1);
            this.closeFile();
            file = new File(this.fileName);
            LogLog.debug((String)("Renaming file " + file + " to " + target));
            file.renameTo(target);
        } else if (this.maxBackupIndex < 0) {
            for (i = 1; i < Integer.MAX_VALUE; ++i) {
                File target = new File(datedFilename + "." + i + SUFFIX_GZIP);
                if (target.exists()) continue;
                this.closeFile();
                this.writeGzip(target);
                break;
            }
        }
        try {
            this.setFile(this.fileName, false, this.bufferedIO, this.bufferSize);
        }
        catch (IOException e) {
            LogLog.error((String)("setFile(" + this.fileName + ", false) call failed."), (Throwable)e);
        }
        this.scheduledFilename = datedFilename + SUFFIX_GZIP;
    }

    public synchronized void setFile(String fileName, boolean append, boolean bufferedIO, int bufferSize) throws IOException {
        super.setFile(fileName, append, this.bufferedIO, this.bufferSize);
        if (append) {
            File f = new File(fileName);
            ((CountingQuietWriter)this.qw).setCount(f.length());
        }
    }

    protected void setQWForFiles(Writer writer) {
        this.qw = new CountingQuietWriter(writer, this.errorHandler);
    }

    void timeRollOver() throws IOException {
        if (this.datePattern == null) {
            this.errorHandler.error("Missing DatePattern option in rollOver().");
            return;
        }
        String datedFilename = this.fileName + this.sdf.format(this.now) + SUFFIX_GZIP;
        if (this.scheduledFilename.equals(datedFilename)) {
            return;
        }
        this.closeFile();
        File target = new File(this.scheduledFilename);
        if (target.exists()) {
            target.delete();
        }
        this.writeGzip(target);
        try {
            this.delExpired(target);
        }
        catch (Exception e) {
            this.errorHandler.error("del file call failed.");
        }
        try {
            super.setFile(this.fileName, false, this.bufferedIO, this.bufferSize);
        }
        catch (IOException e) {
            this.errorHandler.error("setFile(" + this.fileName + ", false) call failed.");
        }
        this.scheduledFilename = datedFilename;
    }

    protected void subAppend(LoggingEvent event) {
        long n = System.currentTimeMillis();
        if (n >= this.nextCheck) {
            this.now.setTime(n);
            this.nextCheck = this.rc.getNextCheckMillis(this.now);
            try {
                this.timeRollOver();
            }
            catch (IOException ioe) {
                LogLog.error((String)"rollOver() failed.", (Throwable)ioe);
            }
        } else if (this.fileName != null && ((CountingQuietWriter)this.qw).getCount() >= this.maxFileSize) {
            this.sizeRollOver();
        }
        super.subAppend(event);
    }

    void delExpired(File target) throws Exception {
        Date reservedDate = DateFormatUtil.getDateAfterDay(DateFormatUtil.formatDate(this.now, "yyyy-MM-dd HH:mm:ss"), -this.reserved);
        String fn = StringUtils.isNotBlank((CharSequence)this.fileName) && this.fileName.indexOf("/") > 0 ? this.fileName.substring(this.fileName.lastIndexOf("/") + 1) : this.fileName;
        String startName = fn + "." + DateFormatUtil.formatDate(reservedDate, "yyyy-MM-dd");
        File parent = new File(target.getParent());
        if (null == parent || !parent.isDirectory()) {
            return;
        }
        File[] cs = parent.listFiles((dir, name) -> name.startsWith(startName));
        if (null == cs || cs.length <= 0) {
            return;
        }
        for (File f : cs) {
            if (null == f || !f.isFile() || !f.exists()) continue;
            f.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeGzip(File target) {
        DeflaterOutputStream out = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.fileName);
            out = new GZIPOutputStream(new FileOutputStream(target));
            int count = -1;
            byte[] data = new byte[0x200000];
            while ((count = fis.read(data, 0, 0x200000)) != -1) {
                ((GZIPOutputStream)out).write(data, 0, count);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    class ApolloRollingCalendar
    extends GregorianCalendar {
        private static final long serialVersionUID = -3560331770601814177L;
        int type;

        ApolloRollingCalendar() {
            this.type = -1;
        }

        ApolloRollingCalendar(TimeZone tz, Locale locale) {
            super(tz, locale);
            this.type = -1;
        }

        void setType(int type) {
            this.type = type;
        }

        public long getNextCheckMillis(Date now) {
            return this.getNextCheckDate(now).getTime();
        }

        public Date getNextCheckDate(Date now) {
            this.setTime(now);
            switch (this.type) {
                case 0: {
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(12, 1);
                    break;
                }
                case 1: {
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(11, 1);
                    break;
                }
                case 2: {
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    int hour = this.get(11);
                    if (hour < 12) {
                        this.set(11, 12);
                        break;
                    }
                    this.set(11, 0);
                    this.add(5, 1);
                    break;
                }
                case 3: {
                    this.set(11, 0);
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(5, 1);
                    break;
                }
                case 4: {
                    this.set(7, this.getFirstDayOfWeek());
                    this.set(11, 0);
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(3, 1);
                    break;
                }
                case 5: {
                    this.set(5, 1);
                    this.set(11, 0);
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(2, 1);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown periodicity type.");
                }
            }
            return this.getTime();
        }
    }
}

