/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.client.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.apollo.client.CompanyConfig;
import com.xforceplus.apollo.client.utils.CommonTools;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.core.common.domain.JsonResult;
import com.xforceplus.core.common.domain.SealedRecMessage;
import com.xforceplus.core.common.domain.XReceiveMsgType;
import com.xforceplus.core.handle.BaseReceiveMsgServiceHandle;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XReceiveMsgType(value="invoicePurchaserPush")
public class PurchaserInvoicePushListener
extends BaseReceiveMsgServiceHandle {
    private static final Logger log = LoggerFactory.getLogger(PurchaserInvoicePushListener.class);

    public JsonResult process(SealedRecMessage sealedRecMessage) {
        String str = sealedRecMessage.getPayload().getObj().toString();
        log.info("\u8fdb\u9879\u534f\u540c\u53cd\u9988\uff1a{}", (Object)str);
        JSONObject json = new JSONObject();
        json.put("status", (Object)1);
        json.put("msg", (Object)"success");
        try {
            JSONObject jsonObject = JSON.parseObject((String)str);
            JSONObject mainJson = jsonObject.getJSONObject("purchaserInvoiceMain");
            String settlementNo = mainJson.get((Object)"settlementNo").toString();
            String project = settlementNo.substring(0, settlementNo.indexOf("_"));
            if ("BPMFYBX".equals(project)) {
                JSONArray resultJsonArray = new JSONArray();
                JSONObject resultJson = new JSONObject();
                JSONObject purchaserInvoiceMainObject = this.getData(mainJson);
                JSONArray resutDetailJsonArray = new JSONArray();
                JSONArray detailJson = jsonObject.getJSONArray("purchaserInvoiceDetails");
                detailJson.forEach(a -> this.getDetailData(a, resutDetailJsonArray));
                resultJson.put("purchaserInvoiceMain", (Object)purchaserInvoiceMainObject);
                resultJson.put("purchaserInvoiceDetails", (Object)resutDetailJsonArray);
                resultJsonArray.add((Object)resultJson);
                json.put("result", (Object)resultJsonArray);
                Service service = new Service();
                String url = CompanyConfig.CUSTOMER_INVOICE_SERVICES + "/ForAjax/InvoiceServices.asmx";
                String namespace = "http://tempuri.org/";
                String actionUri = "http://tempuri.org/InvoiceCheckResult";
                String op = "InvoiceCheckResult";
                Call call = (Call)service.createCall();
                call.setTargetEndpointAddress(new URL(url));
                call.setUseSOAPAction(true);
                call.setSOAPActionURI(actionUri);
                call.setOperationName(new QName(namespace, op));
                call.addParameter(new QName(namespace, "json"), javax.xml.rpc.encoding.XMLType.XSD_STRING, ParameterMode.IN);
                call.setReturnType(XMLType.XSD_STRING);
                String objectJson = JacksonUtil.getInstance().toJson((Object)json);
                Object[] params = new Object[]{objectJson};
                String string = (String)call.invoke(params);
            }
        }
        catch (Exception e) {
            log.error("\u534f\u540c\u9519\u8bef\u65e5\u5fd7:{}", (Throwable)e);
        }
        return JsonResult.ok();
    }

    private JSONObject getData(JSONObject invoiceMain) {
        JSONObject purchaserInvoiceMainObject = new JSONObject();
        purchaserInvoiceMainObject.put("settlementNo", (Object)CommonTools.getStr((Object)invoiceMain.get((Object)"settlementNo")));
        purchaserInvoiceMainObject.put("invoice", (Object)"");
        purchaserInvoiceMainObject.put("isMatching", (Object)"1");
        purchaserInvoiceMainObject.put("isSource", (Object)"1");
        purchaserInvoiceMainObject.put("invoiceNo", (Object)CommonTools.getStr((Object)invoiceMain.get((Object)"invoiceNo")));
        purchaserInvoiceMainObject.put("invoiceCode", (Object)CommonTools.getStr((Object)invoiceMain.get((Object)"invoiceCode")));
        purchaserInvoiceMainObject.put("invoiceType", (Object)CommonTools.getStr((Object)invoiceMain.get((Object)"invoiceType")));
        String scanInvoiceImageUrl = CommonTools.getStr((Object)invoiceMain.get((Object)"scanInvoiceImageUrl"));
        if (!"".equals(scanInvoiceImageUrl)) {
            purchaserInvoiceMainObject.put("imgUrl", (Object)scanInvoiceImageUrl);
        } else {
            purchaserInvoiceMainObject.put("imgUrl", (Object)CommonTools.getStr((Object)invoiceMain.get((Object)"scanDeductionImageUrl")));
        }
        purchaserInvoiceMainObject.put("sellerName", (Object)CommonTools.getStr((Object)invoiceMain.get((Object)"sellerName")));
        purchaserInvoiceMainObject.put("sellerTaxNo", (Object)CommonTools.getStr((Object)invoiceMain.get((Object)"sellerTaxNo")));
        purchaserInvoiceMainObject.put("sellerAddrTel", (Object)CommonTools.getStr((Object)invoiceMain.get((Object)"sellerAddrTel")));
        purchaserInvoiceMainObject.put("sellerBankInfo", (Object)CommonTools.getStr((Object)invoiceMain.get((Object)"sellerBankInfo")));
        purchaserInvoiceMainObject.put("purchaserName", (Object)CommonTools.getStr((Object)invoiceMain.get((Object)"purchaserName")));
        purchaserInvoiceMainObject.put("purchaserTaxNo", (Object)CommonTools.getStr((Object)invoiceMain.get((Object)"purchaserTaxNo")));
        purchaserInvoiceMainObject.put("purchaserAddrTel", (Object)CommonTools.getStr((Object)invoiceMain.get((Object)"purchaserAddrTel")));
        purchaserInvoiceMainObject.put("purchaserBankInfo", (Object)CommonTools.getStr((Object)invoiceMain.get((Object)"purchaserBankInfo")));
        purchaserInvoiceMainObject.put("paperDrewDate", (Object)CommonTools.getStr((Object)invoiceMain.get((Object)"paperDrewDate")));
        purchaserInvoiceMainObject.put("taxRate", (Object)CommonTools.getStr((Object)invoiceMain.get((Object)"taxRate")));
        purchaserInvoiceMainObject.put("taxAmount", (Object)CommonTools.getStr((Object)invoiceMain.get((Object)"taxAmount")));
        purchaserInvoiceMainObject.put("amountWithoutTax", (Object)CommonTools.getStr((Object)invoiceMain.get((Object)"amountWithoutTax")));
        purchaserInvoiceMainObject.put("amountWithTax", (Object)CommonTools.getStr((Object)invoiceMain.get((Object)"amountWithTax")));
        String taxFlag = CommonTools.getStr((Object)invoiceMain.get((Object)"taxFlag"));
        if ("4".equals(taxFlag)) {
            purchaserInvoiceMainObject.put("taxFlag", (Object)"1");
        } else if ("3".equals(taxFlag)) {
            purchaserInvoiceMainObject.put("taxFlag", (Object)"2");
        } else {
            purchaserInvoiceMainObject.put("taxFlag", (Object)"0");
        }
        purchaserInvoiceMainObject.put("authStatus", (Object)CommonTools.getStr((Object)invoiceMain.get((Object)"authStatus")));
        purchaserInvoiceMainObject.put("status", (Object)CommonTools.getStr((Object)invoiceMain.get((Object)"status")));
        purchaserInvoiceMainObject.put("redFlag", (Object)CommonTools.getStr((Object)invoiceMain.get((Object)"redFlag")));
        purchaserInvoiceMainObject.put("retreatStatus", (Object)CommonTools.getStr((Object)invoiceMain.get((Object)"retreatStatus")));
        purchaserInvoiceMainObject.put("remark", (Object)CommonTools.getStr((Object)invoiceMain.get((Object)"remark")));
        return purchaserInvoiceMainObject;
    }

    private void getDetailData(Object obj, JSONArray resutJsonArray) {
        if (null != obj && obj instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)obj;
            JSONObject purchaserInvoiceDetailObject = new JSONObject();
            purchaserInvoiceDetailObject.put("goodsTaxNo", (Object)CommonTools.getStr((Object)jsonObject.get((Object)"goodsTaxNo")));
            purchaserInvoiceDetailObject.put("cargoName", (Object)CommonTools.getStr((Object)jsonObject.get((Object)"cargoName")));
            purchaserInvoiceDetailObject.put("itemSpec", (Object)CommonTools.getStr((Object)jsonObject.get((Object)"itemSpec")));
            purchaserInvoiceDetailObject.put("quantityUnit", (Object)CommonTools.getStr((Object)jsonObject.get((Object)"quantityUnit")));
            purchaserInvoiceDetailObject.put("quantity", (Object)CommonTools.getStr((Object)jsonObject.get((Object)"quantity")));
            purchaserInvoiceDetailObject.put("taxRate", (Object)CommonTools.getStr((Object)jsonObject.get((Object)"taxRate")));
            purchaserInvoiceDetailObject.put("unitPrice", (Object)CommonTools.getStr((Object)jsonObject.get((Object)"unitPrice")));
            purchaserInvoiceDetailObject.put("amountWithTax", (Object)CommonTools.getStr((Object)jsonObject.get((Object)"amountWithTax")));
            purchaserInvoiceDetailObject.put("amountWithoutTax", (Object)CommonTools.getStr((Object)jsonObject.get((Object)"amountWithoutTax")));
            purchaserInvoiceDetailObject.put("taxAmount", (Object)CommonTools.getStr((Object)jsonObject.get((Object)"taxAmount")));
            resutJsonArray.add((Object)purchaserInvoiceDetailObject);
        }
    }
}

